import { Module, forwardRef } from '@nestjs/common';
import { OptionService } from './option.service';
import { OptionController } from './option.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Option, OptionCategory, User } from 'src/common/entities';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { OptionRepository } from './option.repository';


@Module({
  imports: [TypeOrmModule.forFeature([Option, OptionCategory,User]),forwardRef(() => AuthModule), forwardRef(() => UserModule)],
  controllers: [OptionController],
  providers: [OptionService, OptionRepository],
  exports: [OptionService, OptionRepository],
})
export class OptionModule {}
