// import { Test, TestingModule } from '@nestjs/testing';
// import { OptionController } from './option.controller';
// import { OptionService } from './option.service';
// import { CreateOptionDto } from './dto/create-option.dto';
// import { UpdateOptionDto } from './dto/update-option.dto';
// import { OptionType } from 'src/common/enum/option-type.enum';

// describe('OptionController', () => {
//   let controller: OptionController;
//   let service: OptionService;

//   const mockService = {
//     create: jest.fn(),
//     findAll: jest.fn(),
//     findOne: jest.fn(),
//     update: jest.fn(),
//     remove: jest.fn(),
//   };

//   beforeEach(async () => {
//     const module: TestingModule = await Test.createTestingModule({
//       controllers: [OptionController],
//       providers: [
//         {
//           provide: OptionService,
//           useValue: mockService,
//         },
//       ],
//     }).compile();

//     controller = module.get<OptionController>(OptionController);
//     service = module.get<OptionService>(OptionService);
//   });

//   it('should be defined', () => {
//     expect(controller).toBeDefined();
//   });

//   describe('create', () => {
//     it('should create a new option', async () => {
//       const dto: CreateOptionDto = { name: 'Test Option', type: OptionType.STRING, categoryId: 1, createdBy: 1, updatedBy: 1, status: null };
//       const result = { id: 1, ...dto };

//       mockService.create.mockResolvedValue(result);

//       expect(await controller.create(dto)).toEqual({
//         statusCode: 201,
//         message: 'Option created successfully',
//         data: {
//           id: result.id,
//           name: result.name,
//           type: result.type,
//           categoryId: result.categoryId,
//         },
//       });
//       expect(mockService.create).toHaveBeenCalledWith(dto);
//     });
//   });

//   describe('findAll', () => {
//     it('should return all options with default pagination and no searchText', async () => {
//       const result = {
//         data: [{ id: 1, name: 'Option 1', type: 'string', categoryId: 1 }],
//         pagination: { totalPages: 1, pageNumber: 1, pageSize: 10, totalRecords: 1 },
//       };
  
//       mockService.findAll.mockResolvedValue(result);
  
//       expect(await controller.findAll()).toEqual({
//         statusCode: 200,
//         message: 'Options retrieved successfully',
//         data: result.data,
//         pagination: result.pagination,
//       });
//       expect(mockService.findAll).toHaveBeenCalledWith(10, 0, '');
//     });
  
//     it('should return paginated options when limit and offset are provided', async () => {
//       const result = {
//         data: [{ id: 2, name: 'Option 2', type: 'number', categoryId: 2 }],
//         pagination: { totalPages: 2, pageNumber: 2, pageSize: 5, totalRecords: 10 },
//       };
  
//       mockService.findAll.mockResolvedValue(result);
  
//       expect(await controller.findAll(5, 5, '')).toEqual({
//         statusCode: 200,
//         message: 'Options retrieved successfully',
//         data: result.data,
//         pagination: result.pagination,
//       });
//       expect(mockService.findAll).toHaveBeenCalledWith(5, 5, '');
//     });
  
//     it('should return filtered options when searchText is provided', async () => {
//       const result = {
//         data: [{ id: 3, name: 'Filtered Option', type: 'string', categoryId: 3 }],
//         pagination: { totalPages: 1, pageNumber: 1, pageSize: 10, totalRecords: 1 },
//       };
  
//       mockService.findAll.mockResolvedValue(result);
  
//       expect(await controller.findAll(10, 0, 'Filtered')).toEqual({
//         statusCode: 200,
//         message: 'Options retrieved successfully',
//         data: result.data,
//         pagination: result.pagination,
//       });
//       expect(mockService.findAll).toHaveBeenCalledWith(10, 0, 'Filtered');
//     });
  
//     it('should return empty results when no options match the searchText', async () => {
//       const result = {
//         data: [],
//         pagination: { totalPages: 0, pageNumber: 1, pageSize: 10, totalRecords: 0 },
//       };
  
//       mockService.findAll.mockResolvedValue(result);
  
//       expect(await controller.findAll(10, 0, 'NonExistent')).toEqual({
//         statusCode: 200,
//         message: 'Options retrieved successfully',
//         data: result.data,
//         pagination: result.pagination,
//       });
//       expect(mockService.findAll).toHaveBeenCalledWith(10, 0, 'NonExistent');
//     });
//   });

//    describe('findOne', () => {
//     it('should return an option by ID', async () => {
//       const result = { 
//         id: 1, 
//         name: 'Option 1', 
//         type: 'string', 
//         categoryId: 1,
//         category: { id: 1, name: 'Category 1' }, // Add category property
//       };
  
//       mockService.findOne.mockResolvedValue(result);
  
//       expect(await controller.findOne(1)).toEqual({
//         statusCode: 200,
//         message: 'Option retrieved successfully',
//         data: result,
//       });
//       expect(mockService.findOne).toHaveBeenCalledWith(1);
//     });
//   });

//   describe('update', () => {
//     it('should update an option by ID', async () => {
//       const dto: UpdateOptionDto = { name: 'Updated Option', type: OptionType.STRING, categoryId: 1, updatedBy: 1 };
//       const resultDto = {
//         id: 1,
//         name: 'Updated Option',
//         type: OptionType.STRING,
//         categoryId: 1,
//       };
//       const result = { 
//         ...resultDto,
//         category: { id: 1, name: 'Category 1' }, // Add category property
//       };
  
//       mockService.update.mockResolvedValue(result);
  
//       expect(await controller.update(1, dto)).toEqual({
//         statusCode: 200,
//         message: 'Option updated successfully',
//         data: result,
//       });
//       expect(mockService.update).toHaveBeenCalledWith(1, dto);
//     });
//   });

//   describe('remove', () => {
//     it('should delete an option by ID', async () => {
//       mockService.remove.mockResolvedValue(undefined);

//       expect(await controller.remove(1)).toEqual({
//         statusCode: 200,
//         message: 'Option deleted successfully',
//       });
//       expect(mockService.remove).toHaveBeenCalledWith(1);
//     });
//   });
// });