import { ApiProperty } from '@nestjs/swagger';
import { IsString, IsOptional, IsArray, IsObject, IsBoolean } from 'class-validator';
import { Type } from 'class-transformer';
import { ValidateNested } from 'class-validator';
import { TrackInfo } from './email-communication.dto';

export class WhatsAppParameter {
  @ApiProperty()
  @IsString()
  name: string;

  @ApiProperty()
  @IsString()
  value: string;
}

export class SendTemplateMessageDto {
  @ApiProperty()
  @IsString()
  whatsappNumber: string;

  @ApiProperty()
  @IsString()
  templateName: string;

  @ApiProperty()
  @IsString()
  broadcastName: string;

  @ApiProperty({ required: false, type: [WhatsAppParameter] })
  @IsOptional()
  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => WhatsAppParameter)
  parameters?: WhatsAppParameter[];

  @ApiProperty({ required: false, type: TrackInfo })
  @IsOptional()
  @ValidateNested()
  @Type(() => TrackInfo)
  trackinfo?: TrackInfo;
}

export class SendSessionMessageDto {
  @ApiProperty()
  @IsString()
  whatsappNumber: string;

  @ApiProperty()
  @IsString()
  message: string;
}

export class WhatsAppWebhookDto {
  @ApiProperty({ enum: ['sent', 'delivered', 'read', 'failed', 'message'] })
  @IsString()
  eventType: 'sent' | 'delivered' | 'read' | 'failed' | 'message';

  @ApiProperty()
  @IsString()
  whatsappNumber: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  senderName?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  message?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  messageId?: string;

  @ApiProperty()
  @IsString()
  timestamp: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  status?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsBoolean()
  isGroup?: boolean;

  @ApiProperty({ required: false, type: Object })
  @IsOptional()
  @IsObject()
  data?: Record<string, any>;
}
export class BulkWhatsAppRecipient {
  @ApiProperty()
  @IsString()
  whatsappNumber: string;

  @ApiProperty({ required: false, type: [WhatsAppParameter] })
  @IsOptional()
  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => WhatsAppParameter)
  customParams?: WhatsAppParameter[];
}

export class SendBulkTemplateMessageDto {
  @ApiProperty({ type: [BulkWhatsAppRecipient] })
  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => BulkWhatsAppRecipient)
  recipients: BulkWhatsAppRecipient[];

  @ApiProperty()
  @IsString()
  templateName: string;

  @ApiProperty()
  @IsString()
  broadcastName: string;

  @ApiProperty({ required: false, type: [WhatsAppParameter] })
  @IsOptional()
  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => WhatsAppParameter)
  globalParameters?: WhatsAppParameter[];
}
