import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';
import { IsNotEmpty, IsNumber, IsEnum, IsOptional, IsString } from 'class-validator';
import { Type } from 'class-transformer';
import { CommunicationTypeEnum } from 'src/common/enum/communication-type.enum';
import { CommunicationStatusEnum } from 'src/common/enum/communication-status.enum';

export class CreateCommunicationTrackDto {
  @ApiProperty()
  @IsNotEmpty()
  @IsNumber()
  @Type(() => Number)
  registrationId: number;

  @ApiProperty({ enum: CommunicationTypeEnum })
  @IsNotEmpty()
  @IsEnum(CommunicationTypeEnum)
  typ: CommunicationTypeEnum;

  @ApiProperty({ enum: CommunicationStatusEnum, required: false })
  @IsOptional()
  @IsEnum(CommunicationStatusEnum)
  stats?: CommunicationStatusEnum;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  failedReason?: string;

  @ApiProperty({ required: false })
  @IsNotEmpty()
  @IsNumber()
  @IsOptional()
  @Type(() => Number)
  createdBy?: number;

  @ApiProperty({ required: false })
  @IsNotEmpty()
  @IsNumber()
  @IsOptional()
  @Type(() => Number)
  updatedBy?: number;
}

export class UpdateCommunicationTrackDto extends PartialType(
  OmitType(CreateCommunicationTrackDto, ['createdBy'] as const),
) {
  @ApiProperty({ required: false })
  @IsOptional()
  @IsNumber()
  @Type(() => Number)
  registrationId?: number;

  @ApiProperty({ enum: CommunicationTypeEnum, required: false })
  @IsOptional()
  @IsEnum(CommunicationTypeEnum)
  typ?: CommunicationTypeEnum;

  @ApiProperty({ enum: CommunicationStatusEnum, required: false })
  @IsOptional()
  @IsEnum(CommunicationStatusEnum)
  stats?: CommunicationStatusEnum;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  failedReason?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsNumber()
  @Type(() => Number)
  updatedBy?: number;
}
