import { forwardRef, Module } from '@nestjs/common';
import { CommunicationService } from './communication.service';
import { CommunicationController } from './communication.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { CommunicationTrack } from 'src/common/entities';
import { AppLoggerService } from 'src/common/services/logger.service';
import { CommunicationRepository } from './communication.repository';
import { CommunicationTemplates } from 'src/common/entities/communication-templates.entity';
import { CommunicationTemplatesRepository } from './repositories/communication-templates.repository';
import { CommunicationTemplatesService } from './service/communication-templates.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';

@Module({
  imports: [
    // ConfigModule.forFeature(communicationConfig),
    // HttpModule,
    TypeOrmModule.forFeature([CommunicationTrack, CommunicationTemplates]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
  ],
  providers: [CommunicationService, AppLoggerService, CommunicationRepository, CommunicationTemplatesRepository, CommunicationTemplatesService],
  controllers: [CommunicationController],
  exports: [CommunicationService,CommunicationRepository],
})
export class CommunicationModule {}
