import { EntityManager } from 'typeorm';
import { Program, ProgramSession } from '../entities';

/**
 * Increment filled seat counts for program and session.
 * @param manager - TypeORM entity manager.
 * @param programId - Program identifier.
 * @param sessionId - Optional session identifier.
 */
export async function incrementSeatCounts(
  manager: EntityManager,
  programId: number,
  sessionId?: number,
): Promise<void> {
  await manager.increment(Program, { id: programId }, 'filledSeats', 1);
  if (sessionId) {
    await manager.increment(ProgramSession, { id: sessionId }, 'reservedSeats', 1);
  }
}


export async function decrementSeatCounts(
  manager: EntityManager,
  programId: number,
  sessionId?: number,
): Promise<void> {
  await manager.decrement(Program, { id: programId }, 'filledSeats', 1);
  if (sessionId) {
    await manager.decrement(ProgramSession, { id: sessionId }, 'reservedSeats', 1);
  }
}