// Utility functions for formatting room allocation history remarks
import { RoomAllocation, ProgramRegistration } from '../entities';

export type HistoryAction = 'create' | 'update' | 'delete' | 'cleared';

export function formatHistoryRemarks(action: HistoryAction, remarks?: string | null): string {
  const actionLabel =
    action === 'create' ? 'Created' :
    action === 'update' ? 'Updated' :
    action === 'delete' ? 'Deleted' :
    'Cleared';

  if (remarks && remarks.trim().length > 0) {
    return `${actionLabel}: ${remarks.trim()}`;
  }
  return actionLabel;
}

export function formatRoomAllocationHistoryRemarks(
  action: string,
  allocation: RoomAllocation,
  reason: string,
  registration: ProgramRegistration
): string {
  const roomInfo = allocation.programRoomInventoryMap?.room
    ? `Room ${allocation.programRoomInventoryMap.room.label || allocation.programRoomInventoryMap.room.roomNumber}`
    : `Room ID ${allocation.programRoomInventoryMapId}`;

  const bedInfo = allocation.bedPosition ? `, Bed ${allocation.bedPosition}` : '';
  const programInfo = registration.allocatedProgram?.name ? ` from ${registration.allocatedProgram.name}` : '';

  return `Allocation ${action}: ${roomInfo}${bedInfo}${programInfo} - Reason: ${reason}. Original remarks: ${allocation.remarks || 'None'}`;
}
