export const generateTimestampedKey = (folder: string, filename: string): string => {
    const timestamp = new Date().toISOString().replace(/[:.]/g, '-').slice(0, -5);
    const extension = filename.split('.').pop();
    const nameWithoutExt = filename.replace(`.${extension}`, '');
    
    return `${folder}/${timestamp}_${nameWithoutExt}.${extension}`;
};
  