import { Entity, PrimaryGeneratedColumn, Column, CreateDateColumn, UpdateDateColumn, OneToMany } from 'typeorm';
import { UserRoleMap } from './user-role-map.entity';

@Entity('user_role')
export class UserRole {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ name: 'name', type: 'varchar', length: 100, unique: true })
  name: string;

  @Column({ name: 'role_key', type: 'varchar', length: 255, nullable: true })
  roleKey: string;

  @Column({ name: 'priority', type: 'int', default: 999, nullable: false })
  priority: number;

  @Column({ name: 'is_system_role', type: 'boolean', default: false, nullable: false })
  isSystemRole: boolean;

  @CreateDateColumn({ name: 'created_at' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at' })
  updatedAt: Date;

  @OneToMany(() => UserRoleMap, (urm) => urm.role)
  userRoleMaps: UserRoleMap[];

  /**
   * Constructor for initializing UserRole attributes
   * @param partial - Partial UserRole object for initialization
   */
  constructor(partial: Partial<UserRole>) {
    Object.assign(this, partial);
  }
}
