import {
  Column,
  Entity,
  PrimaryGeneratedColumn,
  ManyToOne,
  JoinColumn,
  CreateDateColumn,
  UpdateDateColumn,
  DeleteDateColumn,
} from 'typeorm';
import { User } from './user.entity';
import { ProgramRegistration } from './program-registration.entity';
import { UserParticipationSummary } from './user-participation-summary.entity';
import { OriginTypeEnum } from '../enum/origin-type.enum';

@Entity('user_registration_map')
export class UserRegistrationMap {
  @PrimaryGeneratedColumn({ type: 'bigint' })
  id: number;

  @ManyToOne(() => User, { nullable: false, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'user_id' })
  user: User;

  @ManyToOne(() => ProgramRegistration, { nullable: false, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'registration_id' })
  registration: ProgramRegistration;

  @ManyToOne(() => UserParticipationSummary, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'summary_id' })
  summary: UserParticipationSummary | null;

  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'created_by' })
  createdBy: User | null;

  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'updated_by' })
  updatedBy: User | null;

  @Column({
    name: 'origin_type',
    type: 'enum',
    enum: OriginTypeEnum,
    enumName: 'origin_type_enum',
    default: OriginTypeEnum.CODE_INSERTED,
  })
  originType: OriginTypeEnum;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @UpdateDateColumn({
    name: 'updated_at',
    type: 'timestamptz',
    default: () => 'CURRENT_TIMESTAMP',
    onUpdate: 'CURRENT_TIMESTAMP',
  })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamptz', nullable: true })
  deletedAt: Date | null;

  constructor(partial?: Partial<UserRegistrationMap>) {
    if (partial) {
      Object.assign(this, partial);
    }
  }
}
