import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  JoinColumn,
  CreateDateColumn,
  UpdateDateColumn,
} from 'typeorm';
import { ProgramRegistrationSwap } from './program-registration-swap.entity';
import { Program } from './program.entity';
import { User } from './user.entity';

@Entity('hdb_swap_requested_program')
export class SwapRequestedProgram {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ name: 'swap_request_id', type: 'bigint', nullable: true })
  swapRequestId: number;

  @Column({ name: 'program_id', type: 'bigint', nullable: true })
  programId: number;

  @ManyToOne(() => ProgramRegistrationSwap, (swap) => swap.requestedPrograms)
  @JoinColumn({ name: 'swap_request_id' })
  swapRequest: ProgramRegistrationSwap;

  @ManyToOne(() => Program)
  @JoinColumn({ name: 'program_id' })
  program: Program;

  @CreateDateColumn({ name: 'created_at' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at' })
  updatedAt: Date;

  @Column({ name: 'created_by', type: 'bigint', nullable: true })
  createdById: number;

  @ManyToOne(() => User)
  @JoinColumn({ name: 'created_by' })
  createdBy: User;

  @Column({ name: 'updated_by', type: 'bigint', nullable: true })
  updatedById: number;

  @ManyToOne(() => User)
  @JoinColumn({ name: 'updated_by' })
  updatedBy: User;
}
