import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  ManyToOne,
  JoinColumn,
} from 'typeorm';
import { User } from './user.entity';
import { RoomAllocation } from './room-allocation.entity';
import { ProgramRoomInventoryMap } from './program-room-inventory-map.entity';

/**
 * Entity representing the history of room allocations
 * Tracks changes and modifications to room assignments over time
 */
@Entity('room_allocation_history')
export class RoomAllocationHistory {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ name: 'room_allocation_id', type: 'bigint', nullable: false })
  roomAllocationId: number;

  @Column({ name: 'program_room_inventory_map_id', type: 'bigint', nullable: false })
  programRoomInventoryMapId: number;

  @Column({ name: 'registration_id', type: 'bigint', nullable: false })
  registrationId: number;

  @Column({ name: 'remarks', type: 'text', nullable: true })
  remarks: string | null;

  @Column({ name: 'bed_position', type: 'int', nullable: true })
  bedPosition: number | null;

  @CreateDateColumn({ name: 'created_at', type: 'timestamp', nullable: false })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamp', nullable: true })
  updatedAt: Date;

  @Column({ name: 'created_by', type: 'bigint', nullable: false })
  createdById: number;

  @Column({ name: 'updated_by', type: 'bigint', nullable: true })
  updatedById: number | null;

  // Relationships
  @ManyToOne(() => RoomAllocation, (allocation) => allocation.roomAllocationHistories, { nullable: false })
  @JoinColumn({ name: 'room_allocation_id' })
  roomAllocation: RoomAllocation;

  @ManyToOne(() => ProgramRoomInventoryMap, { nullable: false })
  @JoinColumn({ name: 'program_room_inventory_map_id' })
  programRoomInventoryMap: ProgramRoomInventoryMap;

  @ManyToOne(() => User, { nullable: false })
  @JoinColumn({ name: 'created_by' })
  createdBy: User;

  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'updated_by' })
  updatedBy: User;

  constructor(partial: Partial<RoomAllocationHistory>) {
    Object.assign(this, partial);
  }
}