import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  DeleteDateColumn,
  ManyToOne,
  JoinColumn,
} from 'typeorm';
import { User } from './user.entity';
import { RegistrationPair } from './registration-pair.entity';
import { ProgramRegistration } from './program-registration.entity';

/**
 * Entity representing the mapping of program registrations to registration pairs
 * Links individual registrations to their paired counterparts
 */
@Entity('registration_pair_map')
export class RegistrationPairMap {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ name: 'registration_pair_id', type: 'bigint', nullable: false })
  registrationPairId: number;

  @Column({ name: 'registration_id', type: 'bigint', nullable: false })
  registrationId: number;

  @CreateDateColumn({ name: 'created_at', type: 'timestamp', nullable: false })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamp', nullable: true })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamp', nullable: true })
  deletedAt: Date;

  @Column({ name: 'created_by', type: 'bigint', nullable: false })
  createdById: number;

  @Column({ name: 'updated_by', type: 'bigint', nullable: true })
  updatedById: number;

  // Relationships
  @ManyToOne(() => RegistrationPair, (pair) => pair.registrationPairMaps, { nullable: false })
  @JoinColumn({ name: 'registration_pair_id' })
  registrationPair: RegistrationPair;

  @ManyToOne(() => ProgramRegistration, (registration) => registration.registrationPairMaps, { nullable: false })
  @JoinColumn({ name: 'registration_id' })
  registration: ProgramRegistration;

  @ManyToOne(() => User, { nullable: false })
  @JoinColumn({ name: 'created_by' })
  createdBy: User;

  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'updated_by' })
  updatedBy: User;

  constructor(partial: Partial<RegistrationPairMap>) {
    Object.assign(this, partial);
  }
}