import { Entity, PrimaryGeneratedColumn, Column, ManyToOne, JoinColumn } from 'typeorm';
import { RegistrationInvoiceDetail } from './registration-invoice-detail.entity';
import { InvoiceTypeEnum } from '../enum/invoice-type.enum';
import { Auditable } from 'src/audit-history/decorators/auditable.decorator';
import { SkipAudit } from 'src/audit-history/decorators/skip-audit.decorator';
import { skip } from 'node:test';
import { User } from './user.entity';

@Entity('hdb_registration_invoice_basic_history')
@Auditable()
export class RegistrationInvoiceBasicHistory {
  @PrimaryGeneratedColumn('increment', { type: 'int' })
  id: number;

  @Column({ name: 'invoice_id', type: 'bigint', nullable: true })
  invoiceId: number;

  @Column({ name: 'invoice_type', type: 'enum', enum: InvoiceTypeEnum, nullable: true })
  invoiceType: InvoiceTypeEnum;

  @Column({ name: 'invoice_name', type: 'varchar', length: 255, nullable: true })
  invoiceName: string;

  @Column({ name: 'invoice_email', type: 'varchar', length: 255, nullable: true })
  invoiceEmail: string;

  @Column({ name: 'invoice_address', type: 'text', nullable: true })
  invoiceAddress: string;

  @Column({ name: 'pan_number', type: 'varchar', length: 20, nullable: true })
  panNumber: string;

  @Column({ name: 'tds_amount', type: 'decimal', precision: 10, scale: 2, nullable: true })
  tdsAmount: number;

  @Column({ name: 'tan_number', type: 'varchar', length: 20, nullable: true })
  tanNumber: string;

  @Column({ name: 'zip', type: 'varchar', length: 10, nullable: true })
  zip: string;

  @Column({ name: 'gst_number', type: 'varchar', length: 50, nullable: true })
  gstNumber: string;

  @Column({ name: 'created_at', type: 'timestamp' })
  createdAt: Date;

  @Column({ name: 'updated_at', type: 'timestamp', onUpdate: 'CURRENT_TIMESTAMP' })
  updatedAt: Date;

  @Column({ name: 'created_by', type: 'int', nullable: true })
  createdBy: number;

  @Column({ name: 'updated_by', type: 'int', nullable: true })
  updatedBy: number;

  @SkipAudit()
  @ManyToOne(() => RegistrationInvoiceDetail, { nullable: true, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'invoice_id' })
  invoice: RegistrationInvoiceDetail;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'created_by' })
  createdByUser: User;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'updated_by' })
  updatedByUser: User;

  constructor(partial: Partial<RegistrationInvoiceBasicHistory>) {
    Object.assign(this, partial);
  }
}
