import { Entity, PrimaryGeneratedColumn, Column, ManyToOne, CreateDateColumn, UpdateDateColumn, JoinColumn} from 'typeorm';
import { User } from './user.entity';
import { RecommendationLevel } from '../enum/recommendation-level.enum';
import { ProgramRegistration } from './program-registration.entity';
import { Auditable } from 'src/audit-history/decorators/auditable.decorator';
import { SkipAudit } from 'src/audit-history/decorators/skip-audit.decorator';

  
  
@Entity('hdb_program_registration_recommendations')
@Auditable()
export class ProgramRegistrationRecommendations {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ name: 'registration_id', type: 'bigint' })
  registrationId: number;

  @Column({ name: 'recommended_by', type: 'bigint' })
  recommendedBy: number;

  @Column({
    type: 'enum',
    enum: RecommendationLevel,
    name: 'recommendation_key',
    nullable: true,
  })
  recommendationKey: RecommendationLevel;

  @Column({ type: 'boolean', name: 'is_recommended', nullable: true })
  isRecommended: boolean;

  @SkipAudit()
  @Column({ type: 'timestamp', name: 'created_at', nullable: true, default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @SkipAudit()
  @Column({ type: 'timestamp', name: 'updated_at', nullable: true })
  updatedAt: Date;

  @Column({ type: 'text', name: 'recommendation_text', nullable: true })
  recommendationText?: string;

  @Column({ type: 'int', name: 'follow_up_count', nullable: true, default: 0 })
  followUpCount?: number;

  @Column({ name: 'audit_ref_id', type: 'bigint', nullable: true })
  auditRefId: number;

  @Column({ name: 'parent_ref_id', type: 'bigint', nullable: true })
  parentRefId: number;

  @SkipAudit()
  @ManyToOne(() => ProgramRegistration)
  @JoinColumn({ name: 'registration_id' })
  registration: ProgramRegistration;

  @SkipAudit()
  @ManyToOne(() => User)
  @JoinColumn({ name: 'recommended_by' })
  recommendedUser: User;
}