import { REGISTRATION_BINDING_KEYS } from "./constants";

export const ERROR_CODES = {
  QUESTION_CREATOR_NOTFOUND: 'Q_NF_001',
  QUESTION_UPDATOR_NOTFOUND: 'Q_NF_002',
  QUESTION_NOTFOUND: 'Q_NF_003',
  QUESTION_NOTFOUND_OR_UNPUBLISHED: 'Q_NF_004',
  QUESTION_DUPLICATE_BADREQUEST: 'Q_BR_001',
  QUESTION_FIND_BY_ID_FAILED: 'Q_FIND_BY_ID_FAILED',
  QUESTION_FIND_BY_LABEL_TYPE_FAILED: 'Q_FIND_BY_LABEL_TYPE_FAILED',
  QUESTION_SAVE_FAILED: 'Q_SAVE_FAILED',
  QUESTION_DELETE_FAILED: 'Q_DELETE_FAILED',
  QUESTION_COUNT_FAILED: 'Q_COUNT_FAILED',
  QUESTION_ID_REQUIRED: 'Q_ID_REQUIRED',
  QUESTION_BY_PROGRAM_ID_FAILED: 'Q_BY_PROGRAM_ID_FAILED',
  COMMON_DATA_SERVICE_GET_FAILED: 'CDS_GET_FAILED',
  COMMON_DATA_SERVICE_FINDBYID_FAILED: 'CDS_FIND_BY_ID_FAILED',
  COMMON_DATA_SERVICE_SAVE_FAILED: 'CDS_SAVE_FAILED',
  COMMON_DATA_SERVICE_FINDBYDATA_FAILED: 'CDS_UPDATE_FAILED',
  OPTION_CATEGORY_NOTFOUND: 'OC_NF_001',
  OPTION_CATEGORY_UPDATOR_NOTFOUND: 'OC_NF_002',
  OPTION_CATEGORY_DUPLICATE_BADREQUEST: 'OC_BR_001',
  OPTION_CATEGORY_FIND_BY_ID_FAILED: 'OC_FIND_BY_ID_FAILED',
  OPTION_CATEGORY_SAVE_FAILED: 'OC_SAVE_FAILED',
  OPTION_CATEGORY_DELETE_FAILED: 'OC_DELETE_FAILED',
  OPTION_CATEGORY_COUNT_FAILED: 'OC_COUNT_FAILED',
  OPTION_CATEGORY_GET_FAILED: 'OC_GET_FAILED',
  OPTION_CREATOR_NOTFOUND: 'O_NF_001',
  OPTION_UPDATOR_NOTFOUND: 'O_NF_002',
  OPTION_NOTFOUND: 'O_NF_003',
  OPTION_DUPLICATE_BADREQUEST: 'O_BR_001',
  OPTION_FIND_BY_ID_FAILED: 'O_FIND_BY_ID_FAILED',
  OPTION_FIND_BY_LABEL_TYPE_FAILED: 'O_FIND_BY_LABEL_TYPE_FAILED',
  OPTION_SAVE_FAILED: 'O_SAVE_FAILED',
  OPTION_DELETE_FAILED: 'O_DELETE_FAILED',
  OPTION_COUNT_FAILED: 'O_COUNT_FAILED',
  OPTION_GET_FAILED: 'O_GET_FAILED',
  USER_NOTFOUND: 'U_NF_001',
  USER_NOTFOUND_BY_CONCAT_FIELDS: 'U_NF_002',
  USER_EMAIL_ALREADY_EXISTS: 'U_BR_001',
  USER_PHONE_UPDATE_NOT_ALLOWED: 'U_BR_002',
  USER_PHONE_ALREADY_EXISTS: 'U_BR_003',
  USER_EMAIL_MISMATCH: 'U_BR_004',
  USER_PHONE_MISMATCH: 'U_BR_005',
  // question-option mapping
  QUESTION_OPTION_NOTFOUND: 'QO_NF_001',
  QUESTION_OPTION_CREATOR_NOTFOUND: 'QO_NF_002',
  QUESTION_OPTION_UPDATOR_NOTFOUND: 'QO_NF_003',
  QUESTION_OPTION_DUPLICATE_BADREQUEST: 'QO_BR_001',
  QUESTION_OPTION_FIND_BY_ID_FAILED: 'QO_FIND_BY_ID_FAILED',
  QUESTION_OPTION_FIND_ALL_FAILED: 'QO_FIND_ALL_FAILED',
  QUESTION_OPTION_SAVE_FAILED: 'QO_SAVE_FAILED',
  QUESTION_OPTION_UPDATE_FAILED: 'QO_UPDATE_FAILED',
  QUESTION_OPTION_DELETE_FAILED: 'QO_DELETE_FAILED',
  QUESTION_OPTION_GET_FAILED: 'QO_GET_FAILED',
  QUESTION_OPTION_CREATION_FAILED: 'QO_CREATION_FAILED',
  //program
  PROGRAM_CREATOR_NOTFOUND: 'P_NF_001',
  PROGRAM_UPDATOR_NOTFOUND: 'P_NF_002',
  PROGRAM_NOTFOUND: 'P_NF_003',
  PROGRAM_DUPLICATE_BADREQUEST: 'PROGRAM_DUPLICATE_BADREQUEST',
  PROGRAM_FIND_BY_ID_FAILED: 'PROGRAM_FIND_BY_ID_FAILED',
  PROGRAM_SAVE_FAILED: 'PROGRAM_SAVE_FAILED',
  PROGRAM_DELETE_FAILED: 'PROGRAM_DELETE_FAILED',
  PROGRAM_GET_FAILED: 'PROGRAM_GET_FAILED',
  PROGRAM_COUNT_FAILED: 'PROGRAM_COUNT_FAILED',
  PROGRAM_FEE_NOTFOUND: 'PROGRAM_FEE_NOTFOUND',
  PROGRAM_NOT_ALLOCATED: 'PROGRAM_NOT_ALLOCATED',
  //program type
  PROGRAM_TYPE_NOTFOUND: 'PT_NF_001',
  PROGRAM_TYPE_CREATOR_NOTFOUND: 'PT_NF_002',
  PROGRAM_TYPE_UPDATOR_NOTFOUND: 'PT_NF_003',
  PROGRAM_TYPE_GET_FAILED: 'PT_GET_FAILED',
  PROGRAM_TYPE_FIND_BY_ID_FAILED: 'PT_FIND_BY_ID_FAILED',
  PROGRAM_TYPE_COUNT_FAILED: 'PT_COUNT_FAILED',
  PROGRAM_TYPE_SAVE_FAILED: 'PT_SAVE_FAILED',
  PT_SAVE_FAILED: 'PT_SAVE_FAILED',
  PROGRAM_TYPE_DELETE_FAILED: 'PT_DELETE_FAILED',
  PROGRAM_TYPE_FIND_BY_NAME_FAILED: 'PT_FIND_BY_NAME_FAILED',
  PROGRAM_TYPE_DUPLICATE_BADREQUEST: 'PT_BR_001',

  // Form Section
  FORM_SECTION_CREATOR_NOTFOUND: 'FS_NF_001',
  FORM_SECTION_UPDATOR_NOTFOUND: 'FS_NF_002',
  FORM_SECTION_NOTFOUND: 'FS_NF_003',
  FORM_SECTION_DUPLICATE_BADREQUEST: 'FS_BR_001',
  FORM_SECTION_FIND_FAILED: 'FS_FIND_FAILED',
  FORM_SECTION_SAVE_FAILED: 'FS_SAVE_FAILED',
  FORM_SECTION_UPDATE_FAILED: 'FS_UPDATE_FAILED',
  FORM_SECTION_DELETE_FAILED: 'FS_DELETE_FAILED',
  FORM_SECTION_GET_FAILED: 'FS_GET_FAILED',
  FORM_SECTION_COUNT_FAILED: 'FS_COUNT_FAILED',
  FORM_SECTION_EXISTING_MAPPING_CHECK_FAILED: 'FS_EXISTING_MAPPING_CHECK_FAILED',
  FORM_SECTION_SCOPE_VALIDATION_FAILED: 'FS_SCOPE_VALIDATION_FAILED',
  FORM_SECTION_CUSTOM_QUESTION_CREATION_FAILED: 'FS_CUSTOM_QUESTION_CREATION_FAILED',
  FORM_SECTION_OPTION_MAPPING_FAILED: 'FS_OPTION_MAPPING_FAILED',

  // Program Question
  PROGRAM_QUESTION_NOTFOUND: 'PQ_NF_001',
  PROGRAM_QUESTION_CREATOR_NOTFOUND: 'PQ_NF_002',
  PROGRAM_QUESTION_UPDATOR_NOTFOUND: 'PQ_NF_003',
  PROGRAM_QUESTION_DUPLICATE_BADREQUEST: 'PQ_BR_001',
  PROGRAM_SESSION_REQUIRED_FOR_SESSION_LEVEL: 'PQ_BR_002',
  PROGRAM_SESSION_MISMATCH: 'PQ_BR_003',
  PROGRAM_QUESTION_FIND_BY_ID_FAILED: 'PQ_FIND_BY_ID_FAILED',
  PROGRAM_QUESTION_FIND_ALL_FAILED: 'PQ_FIND_ALL_FAILED',
  PROGRAM_QUESTION_SAVE_FAILED: 'PQ_SAVE_FAILED',
  PROGRAM_QUESTION_UPDATE_FAILED: 'PQ_UPDATE_FAILED',
  PROGRAM_QUESTION_DELETE_FAILED: 'PQ_DELETE_FAILED',
  PROGRAM_QUESTION_GET_FAILED: 'PQ_GET_FAILED',
  PROGRAM_QUESTION_CREATION_FAILED: 'PQ_CREATION_FAILED',
  PROGRAM_QUESTION_FETCH_FAILED: 'PQ_FETCH_FAILED',
  PROGRAM_QUESTION_TRANSACTION_FAILED: 'PQ_TRANSACTION_FAILED',
  PROGRAM_QUESTION_VALIDATION_FAILED: 'PQ_VALIDATION_FAILED',
  PROGRAM_QUESTION_BULK_UPDATE_FAILED: 'PQ_BULK_UPDATE_FAILED',
  PROGRAM_QUESTION_BULK_DELETE_FAILED: 'PQ_BULK_DELETE_FAILED',
  PROGRAM_QUESTION_SECTION_DELETE_FAILED: 'PQ_SECTION_DELETE_FAILED',
  PROGRAM_QUESTION_EXISTING_MAPPING_CHECK_FAILED: 'PQ_EXISTING_MAPPING_CHECK_FAILED',
  PROGRAM_QUESTION_SCOPE_VALIDATION_FAILED: 'PQ_SCOPE_VALIDATION_FAILED',
  PROGRAM_QUESTION_CUSTOM_QUESTION_CREATION_FAILED: 'PQ_CUSTOM_QUESTION_CREATION_FAILED',
  PROGRAM_QUESTION_OPTION_MAPPING_FAILED: 'PQ_OPTION_MAPPING_FAILED',

  // Form Schema Service
  FORM_SCHEMA_GENERATION_FAILED: 'FORM_SCHEMA_001',
  FORM_SCHEMA_PROCESSING_FAILED: 'FORM_SCHEMA_002',
  QUESTION_CREATION_FAILED: 'FORM_SCHEMA_003',
  PROGRAM_METADATA_REQUIRED: 'FORM_SCHEMA_004',
  PROGRAM_METADATA_NOT_FOUND: 'FORM_SCHEMA_005',
  PROGRAM_METADATA_INVALID: 'FORM_SCHEMA_006',

  PROGRAM_SESSION_CREATOR_NOTFOUND: 'PS_NF_001',
  PROGRAM_SESSION_UPDATOR_NOTFOUND: 'PS_NF_002',
  PROGRAM_SESSION_NOTFOUND: 'PS_NF_003',
  PROGRAM_SESSION_DUPLICATE_BADREQUEST: 'PS_BR_001',
  PROGRAM_SESSION_FIND_BY_ID_FAILED: 'PS_FIND_BY_ID_FAILED',
  PROGRAM_SESSION_SAVE_FAILED: 'PS_SAVE_FAILED',
  PROGRAM_SESSION_DELETE_FAILED: 'PS_DELETE_FAILED',
  PROGRAM_SESSION_GET_FAILED: 'PS_GET_FAILED',
  PROGRAM_SESSION_COUNT_FAILED: 'PS_COUNT_FAILED',
  // Program Registration
  PROGRAM_REGISTRATION_NOTFOUND: 'PR_NF_001',
  PROGRAM_REGISTRATION_SAVE_FAILED: 'PR_SAVE_FAILED',
  PROGRAM_REGISTRATION_DELETE_FAILED: 'PR_DELETE_FAILED',
  PROGRAM_REGISTRATION_GET_FAILED: 'PR_GET_FAILED',
  PROGRAM_REGISTRATION_FIND_BY_ID_FAILED: 'PR_FIND_BY_ID_FAILED',
  INVALID_PROGRAM_SESSION: 'PR_INVALID_SESSION',
  PROGRAM_REGISTRATION_RM_RATING_SAVE_FAILED: 'PR_RM_RATING_SAVE_FAILED',
  PROGRAM_REGISTRATION_RM_RATING_FAILED: 'PR_RM_RATING_FAILED',
  PROGRAM_REGISTRATION_RM_RATING_NOT_FOUND: 'PR_RM_RATING_NOT_FOUND',
  PROGRAM_REGISTRATION_RM_RATING_UPDATE_FAILED: 'PR_RM_RATING_UPDATE_FAILED',
  PROGRAM_SWAP_REQUEST_UPDATE_FAILED: 'PROGRAM_SWAP_REQUEST_UPDATE_FAILED',
  PROGRAM_SWAP_REQUEST_NOT_FOUND: 'PROGRAM_SWAP_REQUEST_NOT_FOUND',
  PROGRAM_SWAP_REQUEST_GET_FAILED: 'PROGRAM_SWAP_REQUEST_GET_FAILED',
  SWAP_REQUEST_ALREADY_UPDATED: 'SWAP_REQUEST_ALREADY_UPDATED',
  PROGRAM_NOT_FOUND: 'PROGRAM_NOT_FOUND',
  SEATS_ALREADY_FULL: 'SEATS_ALREADY_FULL',
  NO_FILLED_SEATS: 'NO_FILLED_SEATS',
  PROGRAM_REGISTRATION_NOT_FOUND: 'PROGRAM_REGISTRATION_NOT_FOUND',
  TARGET_PROGRAM_NOT_FOUND: 'TARGET_PROGRAM_NOT_FOUND',
  SWAP_REQUEST_ALREADY_EXISTS: 'SWAP_REQUEST_ALREADY_EXISTS',
  INVALID_SWAP_REQUEST_STATUS: 'INVALID_SWAP_REQUEST_STATUS',
  PARENT_FILTER_REQUIRED: 'INVALID_PARENT_FILTER',
  INVALID_REPORT_CODE: 'INVALID_REPORT_CODE',
  ACCESS_DENIED_TO_REPORT: 'ACCESS_DENIED_TO_REPORT',
  NO_DATA_FOUND_FOR_REPORT: 'NO_DATA_FOUND_FOR_REPORT',
  REGISTRATION_CANT_BE_UPDATED: 'REGISTRATION_CANT_BE_UPDATED',

  // Registration Approval
  REGISTRATION_APPROVAL_NOTFOUND: 'RA_NF_001',
  REGISTRATION_APPROVAL_SAVE_FAILED: 'RA_SAVE_FAILED',
  REGISTRATION_APPROVAL_DELETE_FAILED: 'RA_DELETE_FAILED',
  REGISTRATION_APPROVAL_GET_FAILED: 'RA_GET_FAILED',
  REGISTRATION_APPROVAL_FIND_BY_ID_FAILED: 'RA_FIND_BY_ID_FAILED',
  REGISTRATION_APPROVAL_ALREADY_EXISTS: 'RA_ALREADY_EXISTS',
  REGISTRATION_APPROVAL_TRACK_GET_FAILED: 'RA_TRACK_GET_FAILED',
  REGISTRATION_APPROVAL_NEEDED: 'RA_NEEDED',

  // Registration Custom Response
  REGISTRATION_CUSTOM_RESPONSE_NOTFOUND: 'RCR_NF_001',
  REGISTRATION_CUSTOM_RESPONSE_SAVE_FAILED: 'RCR_SAVE_FAILED',
  REGISTRATION_CUSTOM_RESPONSE_DELETE_FAILED: 'RCR_DELETE_FAILED',
  REGISTRATION_CUSTOM_RESPONSE_GET_FAILED: 'RCR_GET_FAILED',
  REGISTRATION_CUSTOM_RESPONSE_FIND_BY_ID_FAILED: 'RCR_FIND_BY_ID_FAILED',

  // Registration Invoice Detail
  REGISTRATION_INVOICE_DETAIL_NOTFOUND: 'RID_NF_001',
  REGISTRATION_INVOICE_DETAIL_SAVE_FAILED: 'RID_SAVE_FAILED',
  REGISTRATION_INVOICE_DETAIL_UPDATE_FAILED: 'RID_UPDATE_FAILED',
  REGISTRATION_INVOICE_DETAIL_DELETE_FAILED: 'RID_DELETE_FAILED',
  REGISTRATION_INVOICE_DETAIL_GET_FAILED: 'RID_GET_FAILED',
  REGISTRATION_INVOICE_DETAIL_FIND_BY_ID_FAILED: 'RID_FIND_BY_ID_FAILED',
  FAILED_TO_GENERATE_PROFORMA_INVOICE_SEQ_NUMBER: 'FAILED_TO_GENERATE_PROFORMA_INVOICE_SEQ_NUMBER',
  INVOICE_SEQUENCE_START_NOT_FOUND: 'INVOICE_SEQUENCE_START_NOT_FOUND',
  PRO_FORMA_INVOICE_SEQUENCE_START_NOT_FOUND: 'PRO_FORMA_INVOICE_SEQUENCE_START_NOT_FOUND',
  INVOICE_SEQUENCE_NUMBER_NOT_FOUND: 'INVOICE_SEQUENCE_NUMBER_NOT_FOUND',
  INVOICE_SEQUENCE_GENERATION_FAILED: 'INVOICE_SEQUENCE_GENERATION_FAILED',

  // Registration Payment Detail
  REGISTRATION_PAYMENT_DETAIL_NOTFOUND: 'RPD_NF_001',
  REGISTRATION_PAYMENT_DETAIL_SAVE_FAILED: 'RPD_SAVE_FAILED',
  REGISTRATION_PAYMENT_DETAIL_DELETE_FAILED: 'RPD_DELETE_FAILED',
  REGISTRATION_PAYMENT_DETAIL_GET_FAILED: 'RPD_GET_FAILED',
  REGISTRATION_PAYMENT_DETAIL_FIND_BY_ID_FAILED: 'RPD_FIND_BY_ID_FAILED',

  // Registration Travel Info
  REGISTRATION_TRAVEL_INFO_NOTFOUND: 'RTI_NF_001',
  REGISTRATION_TRAVEL_INFO_SAVE_FAILED: 'RTI_SAVE_FAILED',
  REGISTRATION_TRAVEL_INFO_DELETE_FAILED: 'RTI_DELETE_FAILED',
  REGISTRATION_TRAVEL_INFO_GET_FAILED: 'RTI_GET_FAILED',
  REGISTRATION_TRAVEL_INFO_FIND_BY_ID_FAILED: 'RTI_FIND_BY_ID_FAILED',

  // Registration Travel Plan
  REGISTRATION_TRAVEL_PLAN_NOTFOUND: 'RTP_NF_001',
  REGISTRATION_TRAVEL_PLAN_SAVE_FAILED: 'RTP_SAVE_FAILED',
  REGISTRATION_TRAVEL_PLAN_DELETE_FAILED: 'RTP_DELETE_FAILED',
  REGISTRATION_TRAVEL_PLAN_GET_FAILED: 'RTP_GET_FAILED',
  REGISTRATION_TRAVEL_PLAN_FIND_BY_ID_FAILED: 'RTP_FIND_BY_ID_FAILED',

  // Registration
  REGISTRATION_GET_FAILED: 'REG_GET_FAILED',
  REGISTRATION_FIND_BY_ID_FAILED: 'REG_FIND_BY_ID_FAILED',
  REGISTRATION_INVALID_QUESTION: 'R_BR_001',
  REGISTRATION_INVALID_STATUS: 'R_BR_002',
  REGISTRATION_PENDING_APPROVAL: 'R_BR_003',
  REGISTRATION_ALREADY_APPROVED: 'R_BR_004',
  REGISTRATION_CREATION_FAILED: 'R_SAVE_FAILED',
  REGISTRATION_NO_SPACE: 'R_NO_SPACE',
  REGISTRATION_FAILURE_SAVE_FAILED: 'RF_SAVE_FAILED',
  USER_ALREADY_REGISTERED: 'USER_ALREADY_REGISTERED',
  REGISTRATION_ALREADY_EXISTS: 'REGISTRATION_ALREADY_EXISTS',
  REGISTRATION_QUESTION_RESPONSE_GET_FAILED: 'R_QR_GET_FAILED',
  REGISTRATION_NOT_FOUND: 'RE_NF_001',
  REGISTRATION_ALREADY_CANCELLED: 'RE_ALREADY_CANCELLED',
  REGISTRATION_CANCEL_FAILED: 'RE_CANCEL_FAILED',
  REGISTRATION_CANCEL_NOT_ALLOWED: 'RE_CANCEL_NOT_ALLOWED',
  REGISTRATION_CANCEL_UNAUTHORIZED: 'RE_CANCEL_UNAUTHORIZED',
  REGISTRATION_ID_REQUIRED: 'RE_ID_REQUIRED',

  // User
  USER_GET_ALL_FAILED: 'USER_GET_ALL_FAILED',
  USER_NOT_FOUND_BY_ROLE: 'USER_NOT_FOUND_BY_ROLE',

  // Invoice
  INVOICE_GENERATION_FAILED: 'INVOICE_GENERATION_FAILED',
  INVOICE_NOTFOUND: 'INVOICE_NF_001',
  EINVOICE_GENERATION_FAILED: 'EINVOICE_GENERATION_FAILED',
  INVOICE_CODE_NOT_FOUND: 'INVOICE_CODE_NOT_FOUND',

  // User Participation
  USER_PARTICIPATION_NOT_FOUND: 'UP_NF_001',
  USER_PARTICIPATION_BY_YEAR_NOT_FOUND: 'UP_NF_002',
  USER_PARTICIPATION_GET_FAILED: 'UP_GET_FAILED',
  USER_PARTICIPATION_STATS_FAILED: 'UP_STATS_FAILED',
  USER_PARTICIPATION_YEAR_COUNT_FAILED: 'UP_YEAR_COUNT_FAILED',
  USER_PARTICIPATION_UNIQUE_PROGRAMS_FAILED: 'UP_UNIQUE_PROGRAMS_FAILED',
  //Payments
  PAYMENT_ALREADY_EXISTS: 'PAYMENT_ALREADY_EXISTS',
  PAYMENT_INITIATION_FAILED: 'PAYMENT_INITIATION_FAILED',
  PAYMENT_UPDATE_FAILED: 'PAYMENT_UPDATE_FAILED',
  PAYMENT_NOTFOUND: 'INVOICE_NF_001',
  PAYMENT_GET_FAILED: 'PAYMENT_GET_FAILED',
  PAYMENT_CREATION_FAILED: 'PAYMENT_CREATION_FAILED',
  PAYMENT_CONFIRMATION_FAILED: 'PAYMENT_CONFIRMATION_FAILED',
  TDS_AMOUNT_INVALID: 'TDS_AMOUNT_INVALID',
  TDS_AMOUNT_EXCEEDS: 'TDS_AMOUNT_EXCEEDS',
  PAYMENT_ALREADY_COMPLETED: 'PAYMENT_ALREADY_COMPLETED',
  RAZORPAY_ORDER_CREATION_FAILED: 'RAZORPAY_ORDER_CREATION_FAILED',
  PAYMENT_EDIT_STATUS_ALREADY_SET: 'PAYMENT_EDIT_STATUS_ALREADY_SET',
  PAYMENT_INCOMPLETE: 'PAYMENT_INCOMPLETE',
  RAZORPAY_PAYMENT_CAPTURE_FAILED: 'RAZORPAY_PAYMENT_CAPTURE_FAILED',

  //webhook
  INVALID_WEBHOOK_SIGNATURE: 'INVALID_WEBHOOK_SIGNATURE',
  WEBHOOK_PROCESSING_FAILED: 'WEBHOOK_PROCESSING_FAILED',
  INVALID_WEBHOOK_DATA: 'INVALID_WEBHOOK_DATA',

  // General
  INTERNAL_SERVER_ERROR: 'INTERNAL_SERVER_ERROR',

  // Program Question
  PQ_ID_REQUIRED: 'PQ_ID_REQUIRED',
  PQ_BULK_DELETE_FAILED: 'PQ_BULK_DELETE_FAILED',
  PQ_SECTION_DELETE_FAILED: 'PQ_SECTION_DELETE_FAILED',
  PQ_EXISTING_MAPPING_CHECK_FAILED: 'PQ_EXISTING_MAPPING_CHECK_FAILED',
  PQ_SCOPE_VALIDATION_FAILED: 'PQ_SCOPE_VALIDATION_FAILED',
  PQ_CUSTOM_QUESTION_CREATION_FAILED: 'PQ_CUSTOM_QUESTION_CREATION_FAILED',
  PQ_OPTION_MAPPING_FAILED: 'PQ_OPTION_MAPPING_FAILED',
  PQ_TRANSACTION_FAILED: 'PQ_TRANSACTION_FAILED',
  PQ_VALIDATION_FAILED: 'PQ_VALIDATION_FAILED',

  // Form Section
  FS_ID_REQUIRED: 'FS_ID_REQUIRED',
  FS_EXISTING_MAPPING_CHECK_FAILED: 'FS_EXISTING_MAPPING_CHECK_FAILED',
  FS_SCOPE_VALIDATION_FAILED: 'FS_SCOPE_VALIDATION_FAILED',
  FS_CUSTOM_QUESTION_CREATION_FAILED: 'FS_CUSTOM_QUESTION_CREATION_FAILED',
  FS_OPTION_MAPPING_FAILED: 'FS_OPTION_MAPPING_FAILED',

  // Registration
  REG_ID_REQUIRED: 'REG_ID_REQUIRED',

  PREFERENCE_SAVE_FAILED: 'PREF_SAVE_FAILED',
  PREFERENCE_DELETE_FAILED: 'PREF_DELETE_FAILED',
  PREFERENCE_GET_FAILED: 'PREF_GET_FAILED',
  PREFERENCE_NOTFOUND: 'PREF_NF_001',
  PREFERENCE_CREATOR_NOTFOUND: 'PREF_NF_002',
  PREFERENCE_UPDATOR_NOTFOUND: 'PREF_NF_003',
  PREFERENCE_DUPLICATE_BADREQUEST: 'PREF_BR_001',
  PREFERENCE_FIND_BY_ID_FAILED: 'PREF_FIND_BY_ID_FAILED',
  PREFERENCE_FIND_BY_REGISTRATION_ID_FAILED: 'PREF_FIND_BY_REGISTRATION_ID_FAILED',
  PREFERENCE_PRIORITY_ORDER_NOT_UNIQUE: 'PREF_PRIORITY_ORDER_NOT_UNIQUE',
  PREFERENCE_ALREADY_EXISTS: 'PREF_ALREADY_EXISTS',
  PREFERENCE_PROGRAM_INVALID_START_DATE: 'PREF_PROGRAM_INVALID_START_DATE',

  // Communication
  FAILED_TO_SEND_EMAIL: 'FAILED_TO_SEND_EMAIL',
  FAILED_TO_SEND_BULK_EMAIL: 'FAILED_TO_SEND_BULK_EMAIL',
  FAILED_TO_HANDLE_EMAIL_WEBHOOK: 'FAILED_TO_HANDLE_EMAIL_WEBHOOK',
  FAILED_TO_SEND_WHATSAPP_MESSAGE: 'FAILED_TO_SEND_WHATSAPP_MESSAGE',
  FAILED_TO_SEND_BULK_WHATSAPP_MESSAGE: 'FAILED_TO_SEND_BULK_WHATSAPP_MESSAGE',
  FAILED_TO_HANDLE_WHATSAPP_WEBHOOK: 'FAILED_TO_HANDLE_WHATSAPP_WEBHOOK',

  // Communication Track
  COMMUNICATION_TRACK_SAVE_FAILED: 'COMMUNICATION_TRACK_SAVE_FAILED',
  COMMUNICATION_TRACK_GET_FAILED: 'COMMUNICATION_TRACK_GET_FAILED',
  COMMUNICATION_TRACK_NOTFOUND: 'COMMUNICATION_TRACK_NOTFOUND',
  COMMUNICATION_TRACK_FIND_BY_ID_FAILED: 'COMMUNICATION_TRACK_FIND_BY_ID_FAILED',
  COMMUNICATION_TRACK_DELETE_FAILED: 'COMMUNICATION_TRACK_DELETE_FAILED',
  COMMUNICATION_TRACK_UPDATE_FAILED: 'COMMUNICATION_TRACK_UPDATE_FAILED',

  // Dashboard
  PROGRAM_DASHBOARD_DATA_GET_FAILED: 'PROGRAM_DASHBOARD_DATA_GET_FAILED',
  MESSAGE_SAVE_FAILED: 'MESSAGE_SAVE_FAILED',
  MESSAGE_GET_FAILED: 'MESSAGE_GET_FAILED',
  MESSAGE_INVALID_SENDER: 'MESSAGE_INVALID_SENDER',
  MESSAGE_INVALID_RECEIVER: 'MESSAGE_INVALID_RECEIVER',
  // Seat Management
  SEAT_COUNT_UPDATE_FAILED: 'SEAT_COUNT_UPDATE_FAILED',
  SEAT_COUNT_GET_FAILED: 'SEAT_COUNT_GET_FAILED',
  SEAT_COUNT_NOTFOUND: 'SEAT_COUNT_NOTFOUND',
  SEAT_COUNT_FIND_BY_ID_FAILED: 'SEAT_COUNT_FIND_BY_ID_FAILED',

  REGISTRATION_NOT_STARTED: 'REGISTRATION_NOT_STARTED',
  REGISTRATION_CLOSED: 'REGISTRATION_CLOSED',

  //prorgram validation
  DUPLICATE_DISPLAY_ORDER: 'DUPLICATE_DISPLAY_ORDER',
  INVALID_CHILD_DISPLAY_ORDER: 'INVALID_CHILD_DISPLAY_ORDER',
  INVALID_PRIMARY_DISPLAY_ORDER: 'INVALID_PRIMARY_DISPLAY_ORDER',
  CANNOT_CHANGE_TO_NON_GROUPED_TYPE: 'CANNOT_CHANGE_TO_NON_GROUPED_TYPE',
  GROUP_ID_MISMATCH: 'GROUP_ID_MISMATCH',
  INVALID_PRIMARY_PROGRAM: 'INVALID_PRIMARY_PROGRAM',
  PRIMARY_PROGRAM_NOT_FOUND: 'PRIMARY_PROGRAM_NOT_FOUND',
  INVALID_GROUP_CONFIGURATION: 'INVALID_GROUP_CONFIGURATION',
  INVALID_ADDRESS_TYPE: 'INVALID_ADDRESS_TYPE',
  INVALID_PINCODE: 'INVALID_PINCODE',
  PROGRAM_TYPE_DOES_NOT_SUPPORT_GROUPING: 'PROGRAM_TYPE_DOES_NOT_SUPPORT_GROUPING',
  CANNOT_UPDATE_GROUPED_PROGRAMS_ON_NON_PRIMARY: 'CANNOT_UPDATE_GROUPED_PROGRAMS_ON_NON_PRIMARY',
  DUPLICATE_GROUP_DISPLAY_ORDER: 'DUPLICATE_GROUP_DISPLAY_ORDER',
  INVALID_GROUP_DISPLAY_ORDER: 'INVALID_GROUP_DISPLAY_ORDER',
  DUPLICATE_PROGRAM_NAMES_IN_GROUP: 'DUPLICATE_PROGRAM_NAMES_IN_GROUP',
  DUPLICATE_PROGRAM_CODES_IN_GROUP: 'DUPLICATE_PROGRAM_CODES_IN_GROUP',
  INVALID_DATE_RANGE: 'INVALID_DATE_RANGE',
  INVALID_REGISTRATION_DATE_RANGE: 'INVALID_REGISTRATION_DATE_RANGE',
  INVALID_SEAT_CONFIGURATION: 'INVALID_SEAT_CONFIGURATION',
  INVALID_TIME_RANGE: 'INVALID_TIME_RANGE',
  INVALID_CHECKIN_CHECKOUT_DATE_RANGE: 'INVALID_CHECKIN_CHECKOUT_DATE_RANGE',
  INVALID_SEAT_COUNT: 'INVALID_SEAT_COUNT',
  INVALID_PROGRAM_HIERARCHY: 'INVALID_PROGRAM_HIERARCHY',

  // AI Communication
  FAILED_TO_ANALYZE: 'FAILED_TO_ANALYZE',
  FAILED_TO_VERIFY_FLIGHT_TICKET: 'FAILED_TO_VERIFY_FLIGHT_TICKET',
  FAILED_TO_EXTRACT_FLIGHT_DATA: 'FAILED_TO_EXTRACT_FLIGHT_DATA',
  PASSENGER_NAME_MISMATCH: 'PASSENGER_NAME_MISMATCH',
  NO_PASSENGER_NAMES_FOUND: 'NO_PASSENGER_NAMES_FOUND',
  FLIGHT_DESTINATION_MISMATCH: 'FLIGHT_DESTINATION_MISMATCH',
  FLIGHT_ORIGIN_MISMATCH: 'FLIGHT_ORIGIN_MISMATCH',
  DUPLICATE_IDS_IN_REQUEST: 'DUPLICATE_IDS_IN_REQUEST',
  INVALID_PROGRAM_IDS: 'INVALID_PROGRAM_IDS',
  INVALID_RETURN_LOCATION: 'INVALID_RETURN_LOCATION',
  PROGRAM_VENUE_CITY_REQUIRED: 'PROGRAM_VENUE_CITY_REQUIRED',
  INVALID_ONGOING_LOCATION: 'INVALID_ONGOING_LOCATION',
  UNABLE_TO_EXTRACT_TEXT: 'UNABLE_TO_EXTRACT_TEXT',
  FILE_NOT_FLIGHT_TICKET: 'FILE_NOT_FLIGHT_TICKET',
  PDF_FILE_CORRUPTED: 'PDF_FILE_CORRUPTED',
  UNSUPPORTED_FILE_FORMAT: 'UNSUPPORTED_FILE_FORMAT',
  FILE_CORRUPTED: 'FILE_CORRUPTED',
  FILE_UNREADABLE: 'FILE_UNREADABLE',
  TICKET_UNREADABLE: 'TICKET_UNREADABLE',
  AIRLINE_NUMBER_EXTRACTION_FAILED: 'AIRLINE_NUMBER_EXTRACTION_FAILED',
  INVALID_FLIGHT_DATE_ONWARD: 'INVALID_FLIGHT_DATE_ONWARD',
  INVALID_FLIGHT_DATE_RETURN: 'INVALID_FLIGHT_DATE_RETURN',
  PROGRAM_DATES_REQUIRED: 'PROGRAM_DATES_REQUIRED',
  PARTIAL_DATA: 'PARTIAL_DATA',
  FLIGHT_NUMBER_EXTRACTION_FAILED: 'FLIGHT_NUMBER_EXTRACTION_FAILED',
  ORIGIN_LOCATION_MISSING: 'ORIGIN_LOCATION_MISSING',
  DESTINATION_LOCATION_MISSING: 'DESTINATION_LOCATION_MISSING',
  DEPARTURE_ARRIVAL_TIME_MISSING: 'DEPARTURE_ARRIVAL_TIME_MISSING',
  ROUND_TRIP_SEGMENTS_MISSING: 'ROUND_TRIP_SEGMENTS_MISSING',
  RETURN_FLIGHT_DETAILS_MISSING: 'RETURN_FLIGHT_DETAILS_MISSING',
  ONWARD_FLIGHT_DETAILS_MISSING: 'ONWARD_FLIGHT_DETAILS_MISSING',
  ONWARD_RETURN_FLIGHT_MISMATCH: 'ONWARD_RETURN_FLIGHT_MISMATCH',

  // Identity Document Related Errors
  INVALID_IDENTITY_DOCUMENT: 'INVALID_IDENTITY_DOCUMENT',
  FAILED_TO_EXTRACT_IDENTITY_DATA: 'FAILED_TO_EXTRACT_IDENTITY_DATA',
  IDENTITY_DOCUMENT_NAME_MISMATCH: 'IDENTITY_DOCUMENT_NAME_MISMATCH',
  IDENTITY_DOCUMENT_TYPE_REQUIRED: 'IDENTITY_DOCUMENT_TYPE_REQUIRED',
  IDENTITY_DOCUMENT_TYPE_MISMATCH: 'IDENTITY_DOCUMENT_TYPE_MISMATCH',

  // Deletion-related errors
  INVALID_DELETION_REQUEST: 'INVALID_DELETION_REQUEST',
  DUPLICATE_IDS_IN_DELETION_REQUEST: 'DUPLICATE_IDS_IN_DELETION_REQUEST',
  INVALID_DELETED_PROGRAM_IDS: 'INVALID_DELETED_PROGRAM_IDS',
  CANNOT_DELETE_PRIMARY_PROGRAM: 'CANNOT_DELETE_PRIMARY_PROGRAM',
  CONFLICTING_PROGRAM_IDS: 'CONFLICTING_PROGRAM_IDS',
  LOOKUP_DATA_GET_FAILED: 'LOOKUP_DATA_GET_FAILED',
  CANCELLATION_REASON_GET_FAILED: 'CANCELLATION_REASON_GET_FAILED',

  // File Upload
  FAILED_TO_GENERATE_FILE_URLS: 'FAILED_TO_GENERATE_FILE_URLS',
  FILE_UPLOAD_FAILED: 'FILE_UPLOAD_FAILED',
  FAILED_TO_GENERATE_UPLOAD_URLS: 'FAILED_TO_GENERATE_UPLOAD_URLS',

  REGISTRATION_TRAVEL_PLAN_UPDATE_FAILED: 'RTP_UPDATE_FAILED',
  REGISTRATION_TRAVEL_PLAN_CREATE_FAILED: 'RTP_CREATE_FAILED',
  REGISTRATION_TRAVEL_INFO_UPDATE_FAILED: 'RTI_UPDATE_FAILED',
  REGISTRATION_TRAVEL_INFO_CREATE_FAILED: 'RTI_CREATE_FAILED',
  REGISTRATION_STATUS_UPDATE_FAILED: 'REG_STATUS_UPDATE_FAILED',

  USER_SESSION_SAVE_FAILED: 'US_SAVE_FAILED',
  USER_SESSION_UPDATE_FAILED: 'US_UPDATE_FAILED',
  USER_SESSION_NOTFOUND: 'US_NF_001',
  OTP_ATTEMPTS_EXCEEDED: 'US_ATTEMPTS',
  OTP_EXPIRED: 'US_EXPIRED',
  AUTH_INVALID_OTP: 'US_INVALID_OTP',
  USER_SAVE_FAILED: 'U_SAVE_FAILED',
  AUTH_INVALID_LOGIN_TYPE: 'AUTH_INVALID_LOGIN_TYPE',
  USER_UPDATE_FAILED: 'U_UPDATE_FAILED',
  USER_CREATION_FAILED: 'U_CREATION_FAILED',
  FEATURE_FLAG_GET_FAILED: 'FF_GET_FAILED',
  FEATURE_FLAG_CHECK_FAILED: 'FF_CHECK_FAILED',

  PAYMENT_NOT_ALLOWED_FOR_FREE_SEAT: 'PAYMENT_NOT_ALLOWED_FOR_FREE_SEAT',

  // program registration recommendations
  PROGRAM_REGISTRATION_RECOMMENDATION_SAVE_FAILED: 'PR_RECOMMENDATION_SAVE_FAILED',
  PROGRAM_REGISTRATION_RECOMMENDATION_NOT_FOUND: 'PR_RECOMMENDATION_NOT_FOUND',
  PROGRAM_REGISTRATION_RECOMMENDATION_UPDATE_FAILED: 'PR_RECOMMENDATION_UPDATE_FAILED',
  PROGRAM_REGISTRATION_RECOMMENDATION_GET_FAILED: 'PR_RECOMMENDATION_GET_FAILED',
  INVALID_ALLOCATED_PROGRAM_SESSION: 'INVALID_ALLOCATED_PROGRAM_SESSION',

  // Registration Payment Details History
  PAYMENT_HISTORY_NOT_FOUND: 'PAYMENT_HISTORY_NOT_FOUND',
  PAYMENT_HISTORY_UPDATE_FAILED: 'PAYMENT_HISTORY_UPDATE_FAILED',
  PAYMENT_HISTORY_SAVE_FAILED: 'PAYMENT_HISTORY_SAVE_FAILED',

  // Communication Templates
  COMMUNICATION_TEMPLATE_NOTFOUND: 'COMMUNICATION_TEMPLATE_NOTFOUND',
  COMMUNICATION_TEMPLATE_GET_FAILED: 'COMMUNICATION_TEMPLATE_GET_FAILED',
  COMMUNICATION_TEMPLATE_FIND_BY_ID_FAILED: 'COMMUNICATION_TEMPLATE_FIND_BY_ID_FAILED',
  COMMUNICATION_TEMPLATE_FIND_BY_KEY_FAILED: 'COMMUNICATION_TEMPLATE_FIND_BY_KEY_FAILED',
  COMMUNICATION_TEMPLATE_SAVE_FAILED: 'COMMUNICATION_TEMPLATE_SAVE_FAILED',
  FAILED_TO_FETCH_TEMPLATE: 'FAILED_TO_FETCH_TEMPLATE',
  COMMUNICATION_TEMPLATE_FIND_BY_KEY_AND_TYPE_FAILED:
    'COMMUNICATION_TEMPLATE_FIND_BY_KEY_AND_TYPE_FAILED',
  FAILED_TO_SEND_PREPARATORY_COMMUNICATION: 'FAILED_TO_SEND_PREPARATORY_COMMUNICATION',
  FAILED_TO_SEND_FIRST_TIMER_COMMUNICATION: 'FAILED_TO_SEND_FIRST_TIMER_COMMUNICATION',
  FAILED_TO_SEND_CHECKLIST_COMMUNICATION: 'FAILED_TO_SEND_CHECKLIST_COMMUNICATION',
  COMMUNICATION_SEND_FAILED: 'COMMUNICATION_SEND_FAILED',
  REGISTRATIONS_NOT_FOUND_TO_SEND_COMMUNICATION: 'REGISTRATIONS_NOT_FOUND_TO_SEND_COMMUNICATION',
  REGISTRATION_TRAVEL_PLAN_COMMUNICATION_FAILED: 'REGISTRATION_TRAVEL_PLAN_COMMUNICATION_FAILED',

  // Payment Edit Request Errors
  PAYMENT_EDIT_REQUEST_NOT_FOUND: 'PAYMENT_EDIT_REQUEST_NOT_FOUND',
  PAYMENT_EDIT_REQUEST_ALREADY_EXISTS: 'PAYMENT_EDIT_REQUEST_ALREADY_EXISTS',
  PAYMENT_EDIT_REQUEST_PROCESSING_FAILED: 'PAYMENT_EDIT_REQUEST_PROCESSING_FAILED',

  // User Program Experience
  USER_PROGRAM_EXPERIENCE_INVALID_LOOKUP: 'UPE_INVALID_LOOKUP',
  USER_PROGRAM_EXPERIENCE_SAVE_FAILED: 'UPE_SAVE_FAILED',
  USER_PROGRAM_EXPERIENCE_UPDATE_FAILED: 'UPE_UPDATE_FAILED',
  USER_PROGRAM_EXPERIENCE_GET_FAILED: 'UPE_GET_FAILED',
  USER_PROGRAM_EXPERIENCE_DELETE_FAILED: 'UPE_DELETE_FAILED',
  USER_PROGRAM_EXPERIENCE_LOOKUP_FAILED: 'UPE_LOOKUP_FAILED',
  USER_PROGRAM_EXPERIENCE_REGISTRATION_MISMATCH: 'UPE_REGISTRATION_MISMATCH',
  USER_REGISTRATION_MAP_SAVE_FAILED: 'URM_SAVE_FAILED',
  USER_REGISTRATION_MAP_UPDATE_FAILED: 'URM_UPDATE_FAILED',
  USER_REGISTRATION_MAP_DELETE_FAILED: 'URM_DELETE_FAILED',
  USER_REGISTRATION_MAP_GET_FAILED: 'URM_GET_FAILED',
  USER_REGISTRATION_MAP_NOT_FOUND: 'URM_NOT_FOUND',
  USER_REGISTRATION_MAP_REGISTRATION_NOT_COMPLETED: 'URM_REG_NOT_COMPLETED',
  USER_REGISTRATION_MAP_REGISTRATION_MISMATCH: 'URM_REG_MISMATCH',
  USER_REGISTRATION_MAP_USER_MISMATCH: 'URM_USER_MISMATCH',
  USER_REGISTRATION_MAP_SUMMARY_FAILED: 'URM_SUMMARY_FAILED',
  USER_REGISTRATION_MAP_RESTORE_FAILED: 'URM_RESTORE_FAILED',

  // Registration Clear Operations
  REGISTRATION_CLEAR_NOT_ALLOWED: 'REGISTRATION_CLEAR_NOT_ALLOWED',
  REGISTRATION_CLEAR_NOT_ENABLED: 'REGISTRATION_CLEAR_NOT_ENABLED', 
  REGISTRATION_CLEAR_FAILED: 'REGISTRATION_CLEAR_FAILED',

  // Room Allocation
  ROOM_ALLOCATION_NOT_FOUND: 'ROA_NF_001',
  ROOM_ALLOCATION_ALREADY_EXISTS: 'ROA_ALREADY_EXISTS',
  ROOM_ALLOCATION_CREATE_FAILED: 'ROA_CREATE_FAILED',
  ROOM_ALLOCATION_UPDATE_FAILED: 'ROA_UPDATE_FAILED',
  ROOM_ALLOCATION_DELETE_FAILED: 'ROA_DELETE_FAILED',
  ROOM_ALLOCATION_GET_FAILED: 'ROA_GET_FAILED',
  ROOM_ALLOCATION_FIND_FAILED: 'ROA_FIND_FAILED',
  BED_POSITION_ALREADY_OCCUPIED: 'ROA_BED_OCCUPIED',
  ROOM_ALLOCATION_CREATOR_NOTFOUND: 'ROA_NF_002',
  ROOM_ALLOCATION_UPDATOR_NOTFOUND: 'ROA_NF_003',
  ROOM_ALLOCATION_COUNT_FAILED: 'ROA_COUNT_FAILED',
  ROOM_ALLOCATION_FIND_BY_ID_FAILED: 'ROA_FIND_BY_ID_FAILED',
  ROOM_ALLOCATION_FIND_BY_REGISTRATION_ID_FAILED: 'ROA_FIND_BY_REGISTRATION_ID_FAILED',
  ROOM_ALLOCATION_FIND_BY_ROOM_INVENTORY_FAILED: 'ROA_FIND_BY_ROOM_INVENTORY_FAILED',
  ROOM_ALLOCATION_DUPLICATE_BADREQUEST: 'ROA_BR_001',
  ROOM_ALLOCATION_INVALID_BEDPOSITION: 'ROA_BR_002',
  ROOM_ALLOCATION_CAPACITY_EXCEEDED: 'ROA_BR_003',
  ROOM_ALLOCATION_PROGRAM_MISMATCH: 'ROA_BR_004',
  ROOM_ALLOCATION_VALIDATION_FAILED: 'ROA_VALIDATION_FAILED',
  ROOM_ALLOCATION_TRANSACTION_FAILED: 'ROA_TRANSACTION_FAILED',
  ROOM_ALLOCATION_BULK_CREATE_FAILED: 'ROA_BULK_CREATE_FAILED',
  ROOM_ALLOCATION_BULK_DELETE_FAILED: 'ROA_BULK_DELETE_FAILED',
  ROOM_ALLOCATION_BULK_UPDATE_FAILED: 'ROA_BULK_UPDATE_FAILED',
  ROOM_ALLOCATION_OCCUPANCY_STATS_FAILED: 'ROA_OCCUPANCY_STATS_FAILED',
  ROOM_ALLOCATION_STATUS_UPDATE_FAILED: 'ROA_STATUS_UPDATE_FAILED',
  ROOM_ALLOCATION_ID_REQUIRED: 'ROA_ID_REQUIRED',
  BED_POSITION_INVALID: 'ROA_BED_INVALID',
  BED_POSITION_OUT_OF_RANGE: 'ROA_BED_OUT_OF_RANGE',
  ROOM_CAPACITY_NOT_AVAILABLE: 'ROA_ROOM_CAPACITY_NA',
  ROOM_STATUS_INVALID: 'ROA_ROOM_STATUS_INVALID',
  DUPLICATE_REGISTRATION_IDS: 'ROA_DUPLICATE_REG_IDS',
  DUPLICATE_BED_POSITIONS: 'ROA_DUPLICATE_BED_POSITIONS',
  INSUFFICIENT_ROOM_CAPACITY: 'ROA_INSUFFICIENT_CAPACITY',
  ROOM_ALLOCATION_DUPLICATE_IDS: 'ROA_DUPLICATE_ALLOCATION_IDS',
  ROOM_ALLOCATION_ROOM_MISMATCH: 'ROA_ROOM_MISMATCH',
  ROOM_ALLOCATION_TRANSFER_FAILED: 'ROA_TRANSFER_FAILED',
  INVALID_ALLOCATION_DATA: 'ROA_INVALID_ALLOCATION_DATA',
  
  // Room Inventory
  ROOM_INVENTORY_NOT_FOUND: 'ROA_ROOM_INVENTORY_NF',
  ROOM_INVENTORY_GET_FAILED: 'RI_GET_FAILED',
  ROOM_INVENTORY_FIND_BY_ID_FAILED: 'RI_FIND_BY_ID_FAILED',
  ROOM_INVENTORY_SAVE_FAILED: 'RI_SAVE_FAILED',
  ROOM_INVENTORY_UPDATE_FAILED: 'RI_UPDATE_FAILED',
  ROOM_INVENTORY_DELETE_FAILED: 'RI_DELETE_FAILED',
  ROOM_INVENTORY_VALIDATION_FAILED: 'RI_VALIDATION_FAILED',
  ROOM_INVENTORY_RESERVED_WITH_ALLOCATIONS: 'RI_RESERVED_WITH_ALLOCATIONS',
  ROOM_ALLOCATION_RESERVED_ROOM: 'RI_RESERVED_ROOM',
  ROOM_INVENTORY_KPI_CALCULATION_FAILED: 'RI_KPI_CALCULATION_FAILED',
  ROOM_INVENTORY_FILTER_CONFIG_FAILED: 'RI_FILTER_CONFIG_FAILED',
  ROOM_INVENTORY_PAGINATION_FAILED: 'RI_PAGINATION_FAILED',
  ROOM_INVENTORY_VENUE_FETCH_FAILED: 'RI_VENUE_FETCH_FAILED',
  ROOM_INVENTORY_BLOCK_FETCH_FAILED: 'RI_BLOCK_FETCH_FAILED',
  ROOM_INVENTORY_FLOOR_FETCH_FAILED: 'RI_FLOOR_FETCH_FAILED',
  ROOM_INVENTORY_ROOM_TYPE_FETCH_FAILED: 'RI_ROOM_TYPE_FETCH_FAILED',
  ROOM_INVENTORY_BED_TYPE_FETCH_FAILED: 'RI_BED_TYPE_FETCH_FAILED',
  ROOM_INVENTORY_OCCUPANCY_RANGE_FAILED: 'RI_OCCUPANCY_RANGE_FAILED',
  ROOM_ALLOCATION_FILTER_CONFIG_FAILED: 'ROA_FILTER_CONFIG_FAILED',

  // Program Room Inventory Map
  PROGRAM_ROOM_INVENTORY_MAP_NOT_FOUND: 'PRIM_NF_001',
  PROGRAM_ROOM_INVENTORY_MAP_VALIDATION_FAILED: 'PRIM_VALIDATION_FAILED',
  PROGRAM_ROOM_INVENTORY_MAP_CAPACITY_CHECK_FAILED: 'PRIM_CAPACITY_CHECK_FAILED',
  PROGRAM_ROOM_INVENTORY_MAP_OCCUPANCY_UPDATE_FAILED: 'PRIM_OCCUPANCY_UPDATE_FAILED',
  PROGRAM_ROOM_INVENTORY_MAP_DEALLOCATION_FAILED: 'PRIM_DEALLOCATION_FAILED',
  PROGRAM_ROOM_INVENTORY_MAP_OCCUPANCY_DETAILS_FAILED: 'PRIM_OCCUPANCY_DETAILS_FAILED',
  PROGRAM_ROOM_INVENTORY_MAP_STATUS_RECALCULATION_FAILED: 'PRIM_STATUS_RECALCULATION_FAILED',
  PROGRAM_ROOM_INVENTORY_MAP_SAVE_FAILED: 'PRIM_SAVE_FAILED',
  PROGRAM_ROOM_INVENTORY_MAP_PROGRAM_MISMATCH: 'PRIM_PROGRAM_MISMATCH',
  PROGRAM_ROOM_INVENTORY_MAP_SUBPROGRAM_MISMATCH: 'PRIM_SUBPROGRAM_MISMATCH',
  PROGRAM_ROOM_INVENTORY_MAP_INSUFFICIENT_CAPACITY: 'PRIM_INSUFFICIENT_CAPACITY',

  REGISTRATION_GROUPING_SAVE_FAILED: 'REGISTRATION_GROUPING_SAVE_FAILED',
  REGISTRATION_GROUPING_GET_FAILED: 'REGISTRATION_GROUPING_GET_FAILED',
  REGISTRATION_GROUPING_UPDATE_FAILED: 'REGISTRATION_GROUPING_UPDATE_FAILED',
  REGISTRATION_GROUPING_DELETE_FAILED: 'REGISTRATION_GROUPING_DELETE_FAILED',
  REGISTRATION_GROUPING_NOTFOUND: 'REGISTRATION_GROUPING_NOTFOUND',
  PAIRING_DUPLICATE: 'PAIRING_DUPLICATE',
  GROUPING_DUPLICATE: 'GROUPING_DUPLICATE',
  REGISTRATION_PAIRING_FAILED: 'REGISTRATION_PAIRING_FAILED',
  PAIRING_LOOKUP_DATA_NOTFOUND: 'LOOKUP_DATA_NOTFOUND',
  REGISTRATION_PAIRING_OR_GROUPING_VALIDATION_FAILED:
    'REGISTRATION_PAIRING_OR_GROUPING_VALIDATION_FAILED',
  REGISTRATION_PAIRING_SAVE_FAILED: 'REGISTRATION_PAIRING_SAVE_FAILED',
  REGISTRATION_PAIRING_GET_FAILED: 'REGISTRATION_PAIRING_GET_FAILED',
  REGISTRATION_PAIRING_DELETE_FAILED: 'REGISTRATION_PAIRING_DELETE_FAILED',
  REGISTRATION_PAIRING_NOTFOUND: 'REGISTRATION_PAIRING_NOTFOUND',
  REGISTRATION_GROUPING_CREATE_FAILED: 'REGISTRATION_GROUPING_CREATE_FAILED',
  REGISTRATION_GROUPING_ADD_FAILED: 'REGISTRATION_GROUPING_ADD_FAILED',
  REGISTRATION_GROUPING_REMOVE_FAILED: 'REGISTRATION_GROUPING_REMOVE_FAILED',
  REGISTRATION_PAIRING_EXCEEDS_MAX_OCCUPANCY: 'REGISTRATION_PAIRING_EXCEEDS_MAX_OCCUPANCY',
  SWAP_REQUEST_CHECK_FAILED: 'SWAP_REQUEST_CHECK_FAILED',
  REGISTRATION_WANTS_SWAP_NOT_FOUND: 'REGISTRATION_WANTS_SWAP_NOT_FOUND',

  SEEKER_EXPERIENCE_SAVE_FAILED: 'SEEKER_EXPERIENCE_SAVE_FAILED',
  SEEKER_EXPERIENCE_UPDATE_FAILED: 'SEEKER_EXPERIENCE_UPDATE_FAILED',
  SEEKER_EXPERIENCE_FETCH_FAILED: 'SEEKER_EXPERIENCE_FETCH_FAILED',
  SEEKER_EXPERIENCE_DELETE_FAILED: 'SEEKER_EXPERIENCE_DELETE_FAILED',
  SEEKER_EXPERIENCE_NOT_FOUND: 'SEEKER_EXPERIENCE_NOT_FOUND',
  SEEKER_PROGRAM_EXPERIENCE_ALREADY_EXISTS: 'SEEKER_PROGRAM_EXPERIENCE_ALREADY_EXISTS',
  SEEKER_EXPERIENCE_REGISTRATION_MISSING: 'SEEKER_EXPERIENCE_REGISTRATION_MISSING',
};
