export interface ActivityLogChange {
  field: string;
  oldValue: any;
  newValue: any;
  displayOldValue?: string;
  displayNewValue?: string;
}

export interface ActivityLogItem {
  requestId: string;
  timestamp: string;
  message: string;
  category: string;
  subCategory?: string;
  performedBy: number | null;
  performedByName: string | null;
  changes?: ActivityLogChange[];
  metadata?: {
    entities: string[];
    actions: string[];
    apiEndpoint?: string;
    httpMethod?: string;
  };
}

export interface IntelligentActivityResponse {
  data: ActivityLogItem[];
  totalActivities: number;
  dateRange: {
    startDate?: string;
    endDate?: string;
  };
//   summary: {
//     categories: { [key: string]: number };
//     totalApiCalls: number;
//   };
}
