import 'reflect-metadata';
import { SKIP_AUDIT_KEY } from '../audit-history.constants';

const DEFAULT_SKIP_FIELDS = [
  'createdAt',
  'updatedAt',
  'createdBy',
  'updatedBy',
  'created_at',
  'updated_at',
  'created_by',
  'updated_by',
];

export function SkipAudit() {
  return function (target: any, propertyKey: string) {
    const existingSkipFields = Reflect.getMetadata(SKIP_AUDIT_KEY, target.constructor) || [];
    Reflect.defineMetadata(
      SKIP_AUDIT_KEY,
      [...existingSkipFields, propertyKey],
      target.constructor,
    );
  };
}

export function getSkipAuditFields(entityOrClass: any): string[] {
  const ctor = typeof entityOrClass === 'function' ? entityOrClass : entityOrClass?.constructor;
  const definedFields = (ctor && Reflect.getMetadata(SKIP_AUDIT_KEY, ctor)) || [];
  return Array.from(new Set([...DEFAULT_SKIP_FIELDS, ...definedFields]));
}
