import { ApiProperty } from '@nestjs/swagger';
import { IsOptional, IsString, IsNumber, IsEnum } from 'class-validator';
import { AddressTypeEnum } from 'src/common/enum/address-type.enum';

export class CreateAddressDto {

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  addr1?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  addr2?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  landmark?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  city?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  state?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  country?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  pincode?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsNumber()
  lat?: number;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsNumber()
  long?: number;

  @ApiProperty({ enum: AddressTypeEnum })
  @IsEnum(AddressTypeEnum)
  type: AddressTypeEnum;
}
