select * from program_v1 order by id desc;
-- ================================================================================================
-- INSERT INTO program_v1 - Create Special TAT Program Oct-Nov 2025
-- ================================================================================================

INSERT INTO program_v1 (
    program,
    program_type_id,
    name,
    description,
    mode_of_operation,
    online_type,
    max_session_duration_days,
    has_multiple_sessions,
    frequency,
    default_start_time,
    default_end_time,
    duration,
    requires_residence,
    involves_travel,
    has_checkin_checkout,
    requires_payment,
    requires_attendance_all_sessions,
    allows_minors,
    allows_proxy_registration,
    requires_approval,
    registration_level,
    waitlist_applicable,
    limited_seats,
    is_grouped_program,
    no_of_session,
    max_capacity,
    total_seats,
    waitlist_trigger_count,
    available_seats,
    filled_seats,
    base_price,
    gst_percentage,
    currency,
    venue,
    status,
    is_active,
    code,
    banner_image_url,
    created_at,
    updated_at,
    deleted_at,
    created_by,
    updated_by,
    cgst,
    sgst,
    igst,
    tds_percent,
    gst_number,
    tds_applicability,
    invoice_sender_name,
    invoice_sender_pan,
    invoice_sender_cin,
    invoice_sender_address,
    helpline_number,
    email_sender_name,
    venue_name_in_emails,
    registration_starts_at,
    registration_ends_at,
    starts_at,
    ends_at,
    launch_date,
    logo_url
) VALUES (
    '2025-SPECIAL',
    (SELECT id FROM program_type_v1 WHERE key = 'PT_TAT'),
    'Special TAT 2025',
    'Special Online TAT Webinar Series',
    'online',
    'webinar',
    1,
    TRUE,
    'yearly',
    '18:00:00',
    '19:30:00',
    '90 minutes',
    FALSE,
    FALSE,
    FALSE,
    TRUE,
    TRUE,
    TRUE,
    FALSE,
    FALSE,
    'session',
    FALSE,
    FALSE,
    FALSE,
    12,
    500,
    500,
    0,
    500,
    0,
    39999.00,
    18.00,
    'INR',
    'Online Webinar',
    'published',
    TRUE,
    'TAT2025SPECIAL',
    'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/tat.jpeg',
    NOW(),
    NOW(),
    NULL,
    -2,
    -2,
    9.00,
    9.00,
    18.00,
    10.00,
    '36AACCI7694H1Z5',
    'base_only',
    'TAT 2025 Special - Online Webinar Series',
    'AACCI7694H',
    'U74900TN2011PTC083263',
    'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India',
    '+91 98416 70000',
    'Team infinitheism',
    'Online Webinar Platform',
    '2025-10-03 00:00:00+05:30',
    '2025-10-13 23:59:59+05:30',
    '2025-10-15 18:00:00+05:30',
    '2025-11-15 19:30:00+05:30',
    '2025-10-03 10:00:00+05:30',
    null
);

UPDATE program_v1
SET sub_program_type = 'PST_TAT'::sub_program_type_enum
WHERE sub_program_type IS NULL and code = 'TAT2025SPECIAL';

-- ================================================================================================
-- INSERT INTO program_session - Create Special TAT Program Sessions
-- ================================================================================================

INSERT INTO program_session (
    program_id,
    name,
    description,
    starts_at,
    ends_at,
    mode_of_operation,
    online_type,
    max_session_duration_days,
    has_multiple_sessions,
    frequency,
    default_start_time,
    default_end_time,
    duration,
    requires_residence,
    involves_travel,
    has_checkin_checkout,
    requires_payment,
    requires_attendance_all_sessions,
    allows_minors,
    allows_proxy_registration,
    requires_approval,
    registration_level,
    waitlist_applicable,
    limited_seats,
    is_grouped_program,
    max_capacity,
    total_seats,
    available_seats,
    filled_seats,
    waitlist_trigger_count,
    venue,
    session_fee,
    base_price,
    gst_percentage,
    cgst,
    sgst,
    igst,
    currency,
    status,
    is_active,
    created_at,
    updated_at,
    created_by,
    updated_by,
    tds_percent,
    gst_number,
    tds_applicability,
    invoice_sender_name,
    invoice_sender_pan,
    invoice_sender_cin,
    invoice_sender_address,
    helpline_number,
    email_sender_name,
    venue_name_in_emails
) VALUES
( (SELECT id FROM program_v1 WHERE code = 'TAT2025SPECIAL'), 'Special TAT 2025 - Session 1',  'Online TAT session', '2025-10-15 12:30:00+00', '2025-10-15 14:00:00+00', 'online', 'webinar', 1, TRUE, 'yearly', '18:00:00', '19:30:00', '90 minutes', FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, 'session', FALSE, FALSE, FALSE, 500, 500, 500, 0, 0, 'Online Webinar', 39999.00, 39999.00, 18.00, 9.00, 9.00, 18.00, 'INR', 'active', TRUE, NOW(), NOW(), -2, -2, 10.00, '36AACCI7694H1Z5', 'base_only', 'TAT 2025 Special', 'AACCI7694H', 'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India', '+91 98416 70000', 'Team infinitheism', 'Online Webinar Platform'),
( (SELECT id FROM program_v1 WHERE code = 'TAT2025SPECIAL'), 'Special TAT 2025 - Session 2',  'Online TAT session', '2025-10-18 12:30:00+00', '2025-10-18 14:00:00+00', 'online', 'webinar', 1, TRUE, 'yearly', '18:00:00', '19:30:00', '90 minutes', FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, 'session', FALSE, FALSE, FALSE, 500, 500, 500, 0, 0, 'Online Webinar', 39999.00, 39999.00, 18.00, 9.00, 9.00, 18.00, 'INR', 'active', TRUE, NOW(), NOW(), -2, -2, 10.00, '36AACCI7694H1Z5', 'base_only', 'TAT 2025 Special', 'AACCI7694H', 'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India', '+91 98416 70000', 'Team infinitheism', 'Online Webinar Platform'),
( (SELECT id FROM program_v1 WHERE code = 'TAT2025SPECIAL'), 'Special TAT 2025 - Session 3',  'Online TAT session', '2025-10-21 12:30:00+00', '2025-10-21 14:00:00+00', 'online', 'webinar', 1, TRUE, 'yearly', '18:00:00', '19:30:00', '90 minutes', FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, 'session', FALSE, FALSE, FALSE, 500, 500, 500, 0, 0, 'Online Webinar', 39999.00, 39999.00, 18.00, 9.00, 9.00, 18.00, 'INR', 'active', TRUE, NOW(), NOW(), -2, -2, 10.00, '36AACCI7694H1Z5', 'base_only', 'TAT 2025 Special', 'AACCI7694H', 'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India', '+91 98416 70000', 'Team infinitheism', 'Online Webinar Platform'),
( (SELECT id FROM program_v1 WHERE code = 'TAT2025SPECIAL'), 'Special TAT 2025 - Session 4',  'Online TAT session', '2025-10-24 12:30:00+00', '2025-10-24 14:00:00+00', 'online', 'webinar', 1, TRUE, 'yearly', '18:00:00', '19:30:00', '90 minutes', FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, 'session', FALSE, FALSE, FALSE, 500, 500, 500, 0, 0, 'Online Webinar', 39999.00, 39999.00, 18.00, 9.00, 9.00, 18.00, 'INR', 'active', TRUE, NOW(), NOW(), -2, -2, 10.00, '36AACCI7694H1Z5', 'base_only', 'TAT 2025 Special', 'AACCI7694H', 'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India', '+91 98416 70000', 'Team infinitheism', 'Online Webinar Platform'),
( (SELECT id FROM program_v1 WHERE code = 'TAT2025SPECIAL'), 'Special TAT 2025 - Session 5',  'Online TAT session', '2025-10-27 12:30:00+00', '2025-10-27 14:00:00+00', 'online', 'webinar', 1, TRUE, 'yearly', '18:00:00', '19:30:00', '90 minutes', FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, 'session', FALSE, FALSE, FALSE, 500, 500, 500, 0, 0, 'Online Webinar', 39999.00, 39999.00, 18.00, 9.00, 9.00, 18.00, 'INR', 'active', TRUE, NOW(), NOW(), -2, -2, 10.00, '36AACCI7694H1Z5', 'base_only', 'TAT 2025 Special', 'AACCI7694H', 'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India', '+91 98416 70000', 'Team infinitheism', 'Online Webinar Platform'),
( (SELECT id FROM program_v1 WHERE code = 'TAT2025SPECIAL'), 'Special TAT 2025 - Session 6',  'Online TAT session', '2025-10-30 12:30:00+00', '2025-10-30 14:00:00+00', 'online', 'webinar', 1, TRUE, 'yearly', '18:00:00', '19:30:00', '90 minutes', FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, 'session', FALSE, FALSE, FALSE, 500, 500, 500, 0, 0, 'Online Webinar', 39999.00, 39999.00, 18.00, 9.00, 9.00, 18.00, 'INR', 'active', TRUE, NOW(), NOW(), -2, -2, 10.00, '36AACCI7694H1Z5', 'base_only', 'TAT 2025 Special', 'AACCI7694H', 'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India', '+91 98416 70000', 'Team infinitheism', 'Online Webinar Platform'),
( (SELECT id FROM program_v1 WHERE code = 'TAT2025SPECIAL'), 'Special TAT 2025 - Session 7',  'Online TAT session', '2025-11-02 12:30:00+00', '2025-11-02 14:00:00+00', 'online', 'webinar', 1, TRUE, 'yearly', '18:00:00', '19:30:00', '90 minutes', FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, 'session', FALSE, FALSE, FALSE, 500, 500, 500, 0, 0, 'Online Webinar', 39999.00, 39999.00, 18.00, 9.00, 9.00, 18.00, 'INR', 'active', TRUE, NOW(), NOW(), -2, -2, 10.00, '36AACCI7694H1Z5', 'base_only', 'TAT 2025 Special', 'AACCI7694H', 'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India', '+91 98416 70000', 'Team infinitheism', 'Online Webinar Platform'),
( (SELECT id FROM program_v1 WHERE code = 'TAT2025SPECIAL'), 'Special TAT 2025 - Session 8',  'Online TAT session', '2025-11-05 12:30:00+00', '2025-11-05 14:00:00+00', 'online', 'webinar', 1, TRUE, 'yearly', '18:00:00', '19:30:00', '90 minutes', FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, 'session', FALSE, FALSE, FALSE, 500, 500, 500, 0, 0, 'Online Webinar', 39999.00, 39999.00, 18.00, 9.00, 9.00, 18.00, 'INR', 'active', TRUE, NOW(), NOW(), -2, -2, 10.00, '36AACCI7694H1Z5', 'base_only', 'TAT 2025 Special', 'AACCI7694H', 'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India', '+91 98416 70000', 'Team infinitheism', 'Online Webinar Platform'),
( (SELECT id FROM program_v1 WHERE code = 'TAT2025SPECIAL'), 'Special TAT 2025 - Session 9',  'Online TAT session', '2025-11-08 12:30:00+00', '2025-11-08 14:00:00+00', 'online', 'webinar', 1, TRUE, 'yearly', '18:00:00', '19:30:00', '90 minutes', FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, 'session', FALSE, FALSE, FALSE, 500, 500, 500, 0, 0, 'Online Webinar', 39999.00, 39999.00, 18.00, 9.00, 9.00, 18.00, 'INR', 'active', TRUE, NOW(), NOW(), -2, -2, 10.00, '36AACCI7694H1Z5', 'base_only', 'TAT 2025 Special', 'AACCI7694H', 'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India', '+91 98416 70000', 'Team infinitheism', 'Online Webinar Platform'),
( (SELECT id FROM program_v1 WHERE code = 'TAT2025SPECIAL'), 'Special TAT 2025 - Session 10', 'Online TAT session', '2025-11-11 12:30:00+00', '2025-11-11 14:00:00+00', 'online', 'webinar', 1, TRUE, 'yearly', '18:00:00', '19:30:00', '90 minutes', FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, 'session', FALSE, FALSE, FALSE, 500, 500, 500, 0, 0, 'Online Webinar', 39999.00, 39999.00, 18.00, 9.00, 9.00, 18.00, 'INR', 'active', TRUE, NOW(), NOW(), -2, -2, 10.00, '36AACCI7694H1Z5', 'base_only', 'TAT 2025 Special', 'AACCI7694H', 'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India', '+91 98416 70000', 'Team infinitheism', 'Online Webinar Platform'),
( (SELECT id FROM program_v1 WHERE code = 'TAT2025SPECIAL'), 'Special TAT 2025 - Session 11', 'Online TAT session', '2025-11-13 12:30:00+00', '2025-11-13 14:00:00+00', 'online', 'webinar', 1, TRUE, 'yearly', '18:00:00', '19:30:00', '90 minutes', FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, 'session', FALSE, FALSE, FALSE, 500, 500, 500, 0, 0, 'Online Webinar', 39999.00, 39999.00, 18.00, 9.00, 9.00, 18.00, 'INR', 'active', TRUE, NOW(), NOW(), -2, -2, 10.00, '36AACCI7694H1Z5', 'base_only', 'TAT 2025 Special', 'AACCI7694H', 'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India', '+91 98416 70000', 'Team infinitheism', 'Online Webinar Platform'),
( (SELECT id FROM program_v1 WHERE code = 'TAT2025SPECIAL'), 'Special TAT 2025 - Session 12', 'Online TAT session', '2025-11-15 12:30:00+00', '2025-11-15 14:00:00+00', 'online', 'webinar', 1, TRUE, 'yearly', '18:00:00', '19:30:00', '90 minutes', FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, 'session', FALSE, FALSE, FALSE, 500, 500, 500, 0, 0, 'Online Webinar', 39999.00, 39999.00, 18.00, 9.00, 9.00, 18.00, 'INR', 'active', TRUE, NOW(), NOW(), -2, -2, 10.00, '36AACCI7694H1Z5', 'base_only', 'TAT 2025 Special', 'AACCI7694H', 'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India', '+91 98416 70000', 'Team infinitheism', 'Online Webinar Platform');

select id,name,starts_at,ends_at from program_v1 where deleted_at is null and program_type_id =1;


