import { ApiProperty } from '@nestjs/swagger';
import { IsOptional, IsString, IsEmail, IsBoolean, IsDateString, IsEnum, MaxLength, ValidateNested } from 'class-validator';
import { Type } from 'class-transformer';
import { UserTypeEnum } from 'src/common/enum/user-type.enum';
import { UpdateUserProfileExtensionDto } from 'src/user-profile-extension/dto/update-user-profile-extension.dto';

export class UpdateUserDto {
  @ApiProperty({ 
    description: 'User full name', 
    example: 'John Doe',
    required: false 
  })
  @IsOptional()
  @IsString()
  @MaxLength(255)
  fullName?: string;

  @ApiProperty({ example: 'John Doe', required: false })
  @IsOptional()
  @IsString()
  legalFullName?: string;

  @ApiProperty({ 
    description: 'User role', 
    example: 'viewer',
    required: false 
  })
  @IsOptional()
  @IsString()
  @MaxLength(255)
  role?: string;

  @ApiProperty({ 
    description: 'User first name', 
    example: 'John',
    required: false 
  })
  @IsOptional()
  @IsString()
  @MaxLength(255)
  firstName?: string;

  @ApiProperty({ 
    description: 'User last name', 
    example: 'Doe',
    required: false 
  })
  @IsOptional()
  @IsString()
  @MaxLength(255)
  lastName?: string;

  @ApiProperty({ 
    description: 'User phone number', 
    example: '1234567890',
    required: false 
  })
  @IsOptional()
  @IsString()
  @MaxLength(20)
  phoneNumber?: string;

  @ApiProperty({ 
    description: 'User email address', 
    example: 'john.doe@example.com',
    required: false 
  })
  @IsOptional()
  @IsEmail()
  @MaxLength(319)
  email?: string;

  @ApiProperty({
    description: 'User address',
    example: '123 Main St, City, State',
    required: false
  })
  @IsOptional()
  @IsString()
  address?: string;

  @ApiProperty({
    description: 'Country name',
    example: 'India',
    required: false
  })
  @IsOptional()
  @IsString()
  countryName?: string;

  @ApiProperty({ 
    description: 'Country code for phone number', 
    example: '+91',
    required: false 
  })
  @IsOptional()
  @IsString()
  countryCode?: string;

  @ApiProperty({ 
    description: 'User gender', 
    example: 'Male',
    required: false 
  })
  @IsOptional()
  @IsString()
  @MaxLength(10)
  gender?: string;

  @ApiProperty({ 
    description: 'Date of birth', 
    example: '1990-01-01',
    required: false 
  })
  @IsOptional()
  @IsDateString()
  dob?: string;

  @ApiProperty({ 
    description: 'Other address', 
    example: 'Alternate address',
    required: false 
  })
  @IsOptional()
  @IsString()
  otherAddress?: string;

  @ApiProperty({ 
    description: 'User approval status', 
    example: 'approved',
    required: false 
  })
  @IsOptional()
  @IsString()
  @MaxLength(20)
  userApprovalStatus?: string;

  @ApiProperty({ 
    description: 'Profile URL', 
    example: 'https://example.com/profile.jpg',
    required: false 
  })
  @IsOptional()
  @IsString()
  profileUrl?: string;

  @ApiProperty({ 
    description: 'Name audio URL', 
    example: 'https://example.com/name-audio.mp3',
    required: false 
  })
  @IsOptional()
  @IsString()
  nameAudio?: string;

  @ApiProperty({ 
    description: 'Associated since date', 
    example: '2023-01-01',
    required: false 
  })
  @IsOptional()
  @IsDateString()
  associatedSince?: string;

  @ApiProperty({ 
    description: 'Terms and conditions acceptance', 
    example: true,
    required: false 
  })
  @IsOptional()
  @IsBoolean()
  termsAndConditions?: boolean;

  @ApiProperty({ 
    description: 'Alternate country code', 
    example: '+1',
    required: false 
  })
  @IsOptional()
  @IsString()
  @MaxLength(255)
  alternateCountryCode?: string;

  @ApiProperty({ 
    description: 'Alternate phone number', 
    example: '9876543210',
    required: false 
  })
  @IsOptional()
  @IsString()
  @MaxLength(255)
  alternatePhoneNumber?: string;

  @ApiProperty({ 
    description: 'Alternate email', 
    example: 'john.alternate@example.com',
    required: false 
  })
  @IsOptional()
  @IsEmail()
  @MaxLength(255)
  alternateEmail?: string;

  @ApiProperty({ 
    description: 'Is Infiminute user', 
    example: true,
    required: false 
  })
  @IsOptional()
  @IsBoolean()
  isInfiminute?: boolean;

  @ApiProperty({ 
    description: 'Is Infimessages user', 
    example: true,
    required: false 
  })
  @IsOptional()
  @IsBoolean()
  isInfimessages?: boolean;

  @ApiProperty({ 
    description: 'Is Infipath user', 
    example: true,
    required: false 
  })
  @IsOptional()
  @IsBoolean()
  isInfipath?: boolean;

  @ApiProperty({ 
    description: 'Is Infiminute user active', 
    example: true,
    required: false 
  })
  @IsOptional()
  @IsBoolean()
  isInfiminuteUserActive?: boolean;

  @ApiProperty({ 
    description: 'Is Infimessage user active', 
    example: true,
    required: false 
  })
  @IsOptional()
  @IsBoolean()
  isInfimessageUserActive?: boolean;

  @ApiProperty({ 
    description: 'Is Infipath user active', 
    example: true,
    required: false 
  })
  @IsOptional()
  @IsBoolean()
  isInfipathUserActive?: boolean;

  @ApiProperty({
    description: 'User type',
    example: UserTypeEnum.SEEKER,
    enum: UserTypeEnum,
    required: false
  })
  @IsOptional()
  @IsEnum(UserTypeEnum)
  userType?: UserTypeEnum;

  @ApiProperty({ required: false, type: () => UpdateUserProfileExtensionDto })
  @IsOptional()
  @ValidateNested()
  @Type(() => UpdateUserProfileExtensionDto)
  profileExtension?: UpdateUserProfileExtensionDto;
}