import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { UserProgramExperienceController } from './user-program-experience.controller';
import { UserProgramExperienceService } from './user-program-experience.service';
import { UserProgramExperienceRepository } from './user-program-experience.repository';
import { LookupData, ProgramRegistration, User, UserProgramExperience } from 'src/common/entities';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';

@Module({
  imports: [
    TypeOrmModule.forFeature([UserProgramExperience, User, ProgramRegistration, LookupData]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
  ],
  controllers: [UserProgramExperienceController],
  providers: [UserProgramExperienceService, UserProgramExperienceRepository, CommonDataService, AppLoggerService],
  exports: [UserProgramExperienceService, UserProgramExperienceRepository],
})
export class UserProgramExperienceModule {}