import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
  UseGuards,
  HttpCode,
  HttpStatus,
} from '@nestjs/common';
import { UserProfileExtensionService } from './user-profile-extension.service';
import { CreateUserProfileExtensionDto } from './dto/create-user-profile-extension.dto';
import { UpdateUserProfileExtensionDto } from './dto/update-user-profile-extension.dto';
import { FirebaseAuthGuard } from 'src/auth/firebase-auth.guard';

@Controller('user-profile-extension')
@UseGuards(FirebaseAuthGuard)
export class UserProfileExtensionController {
  constructor(
    private readonly userProfileExtensionService: UserProfileExtensionService,
  ) {}

  @Post()
  @HttpCode(HttpStatus.CREATED)
  async create(@Body() createUserProfileExtensionDto: CreateUserProfileExtensionDto) {
    return this.userProfileExtensionService.create(createUserProfileExtensionDto);
  }

  @Get(':userId')
  async findByUserId(@Param('userId') userId: string) {
    return this.userProfileExtensionService.findByUserId(parseInt(userId));
  }

  @Patch(':userId')
  async updateByUserId(
    @Param('userId') userId: string,
    @Body() updateUserProfileExtensionDto: UpdateUserProfileExtensionDto,
  ) {
    return this.userProfileExtensionService.updateByUserId(
      parseInt(userId),
      updateUserProfileExtensionDto,
    );
  }

  @Delete(':id')
  async remove(@Param('id') id: string) {
    return this.userProfileExtensionService.remove(parseInt(id));
  }
}