import { IsOptional, IsString, IsBoolean, IsNumber, IsUUID } from 'class-validator';

export class CreateUserProfileExtensionDto {
  @IsOptional()
  @IsUUID()
  userId?: string;

  @IsOptional()
  @IsString()
  idFrontBackOnlyFromDownloadLink?: string;

  @IsOptional()
  @IsString()
  idBackOnlyDownloadLink?: string;

  @IsOptional()
  @IsString()
  emailToWhichInvoiceToBeSent?: string;

  @IsOptional()
  @IsString()
  nameInWhichInvoiceToBeIssued?: string;

  @IsOptional()
  @IsString()
  invoiceAddress?: string;

  @IsOptional()
  @IsString()
  tan?: string;

  @IsOptional()
  @IsString()
  gstin?: string;

  @IsOptional()
  @IsBoolean()
  areYouRegisteredUnderGst?: boolean;

  @IsOptional()
  @IsString()
  whenWasYourLastHdbMsd?: string;

  @IsOptional()
  @IsString()
  sinceWhenHaveYouBeenAssociatedWithThisPath?: string;

  @IsOptional()
  @IsNumber()
  howManyHdbMsdHaveYouDone?: number;

  @IsOptional()
  @IsString()
  whichOfTheFollowingHaveYouExperienced?: string;

  @IsOptional()
  @IsString()
  songPreference1?: string;

  @IsOptional()
  @IsString()
  songPreference2?: string;

  @IsOptional()
  @IsString()
  contactPerson?: string;

  @IsOptional()
  @IsString()
  hdbYear?: string;

  @IsOptional()
  @IsNumber()
  infinitheismContactId?: number;

  @IsOptional()
  @IsString()
  pincode?: string;
}
