import { GenderEnum } from 'src/common/enum/gender.enum';

/**
 * Normalizes filter values to ensure they match database enum values
 * @param filters - The filters object to normalize
 */
export function normalizeFilterValues(filters: Record<string, any>): void {
  if (!filters) return;

  // Transform gender filter from lowercase to proper enum values
  if (filters.gender) {
    const genderValue = typeof filters.gender === 'string' ? filters.gender.toLowerCase() : filters.gender;
    
    switch (genderValue) {
      case 'male':
        filters.gender = GenderEnum.MALE;
        break;
      case 'female':
        filters.gender = GenderEnum.FEMALE;
        break;
      case 'other':
        filters.gender = GenderEnum.OTHER;
        break;
      case 'prefer not to say':
      case 'prefer_not_to_say':
        filters.gender = GenderEnum.PREFER_NOT_TO_SAY;
        break;
      default:
        // If it's already a proper enum value, keep it as is
        break;
    }
  }
}
