import { ApiProperty } from '@nestjs/swagger';
import { IsArray, IsBoolean, IsEnum, IsInt, IsOptional, IsString, ValidateNested } from 'class-validator';
import { Type } from 'class-transformer';
import { RegistrationStatusEnum } from 'src/common/enum/registration-status.enum';

export class RegistrationAnswerDto {
  @ApiProperty({ description: 'Question ID' })
  @IsInt()
  questionId: number;

  @ApiProperty({ required: false, description: 'Answer for the question', type: Object })
  @IsString()
  answer: any;

  @ApiProperty({ required: false, description: 'Binding key for mapping answers to user profile' })
  @IsOptional()
  @IsString()
  bindingKey?: string;
}

export class CreateRegistrationDto {
  @ApiProperty({ description: 'Program ID' })
  @IsInt()
  programId: number;

  @ApiProperty({ description: 'Program Session ID', required: false })
  @IsOptional()
  @IsInt()
  programSessionId?: number;

  @ApiProperty({ description: 'Is self registration', required: false, type: Boolean })
  @IsOptional()
  isSelfRegister?: boolean;

  @ApiProperty({ enum: RegistrationStatusEnum, required: false })
  @IsOptional()
  @IsEnum(RegistrationStatusEnum)
  registrationStatus?: RegistrationStatusEnum;

  @ApiProperty({ description: 'Flag to update user profile data', required: false, type: Boolean })
  @IsOptional()
  @IsBoolean()
  updateUserProfileData?: boolean;

  @ApiProperty({ description: 'Country code for mobile number', required: false })
  @IsOptional()
  @IsString()
  countryCode?: string;
  
  @ApiProperty({ type: [RegistrationAnswerDto] })
  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => RegistrationAnswerDto)
  answers: RegistrationAnswerDto[];
}