import { ApiProperty } from '@nestjs/swagger';
import { IsInt, IsOptional, IsString } from 'class-validator';

export class CancelRegistrationDto {
  @ApiProperty({ description: 'Program registration ID' })
  @IsInt()
  programRegistrationId: number;

  @ApiProperty({ description: 'Cancellation reason key' })
  @IsString()
  cancellationReason: string;

  @ApiProperty({ required: false, description: 'Additional cancellation comments' })
  @IsOptional()
  @IsString()
  cancellationComments?: string;
}
