import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { RegistrationInvoiceDetail } from 'src/common/entities';
import { RegistrationInvoiceDetailService } from './registration-invoice-detail.service';
import { RegistrationInvoiceDetailController } from './registration-invoice-detail.controller';
import { RegistrationInvoiceDetailRepository } from './registration-invoice-detail.repository';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';

@Module({
  imports: [TypeOrmModule.forFeature([RegistrationInvoiceDetail]), forwardRef(() => AuthModule), forwardRef(() => UserModule)],
  controllers: [RegistrationInvoiceDetailController],
  providers: [RegistrationInvoiceDetailService, RegistrationInvoiceDetailRepository, CommonDataService, AppLoggerService],
  exports: [RegistrationInvoiceDetailService, RegistrationInvoiceDetailRepository],
})
export class RegistrationInvoiceDetailModule {}
