import { PartialType, ApiPropertyOptional } from '@nestjs/swagger';
import {
  CreateRegistrationGroupDto,
  CreateRegistrationPairDto,
} from './create-registration-grouping.dto';
import { IsString, IsNumber, IsOptional } from 'class-validator';

export class UpdateRegistrationGroupDto extends PartialType(CreateRegistrationGroupDto) {
  @ApiPropertyOptional({ description: 'Updated group name' })
  @IsOptional()
  @IsString()
  groupName?: string;

  @ApiPropertyOptional({ description: 'Updated remarks' })
  @IsOptional()
  @IsString()
  remarks?: string;

  @ApiPropertyOptional({ description: 'User ID who is updating this group' })
  @IsOptional()
  @IsNumber()
  updatedBy?: number;
}

export class UpdateRegistrationPairDto extends PartialType(CreateRegistrationPairDto) {
  @ApiPropertyOptional({ description: 'Updated pair code' })
  @IsOptional()
  @IsString()
  pairCode?: string;

  @ApiPropertyOptional({ description: 'Updated remarks' })
  @IsOptional()
  @IsString()
  remarks?: string;

  @ApiPropertyOptional({ description: 'User ID who is updating this pair' })
  @IsOptional()
  @IsNumber()
  updatedBy?: number;
}

export class RemoveRegistrationsDto {
  @ApiPropertyOptional({ description: 'Registration IDs to remove', example: [1, 2] })
  registrationIds: number[];

  @IsOptional()
  @IsNumber()
  updatedBy?: number;
}
