import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { RegistrationCustomResponse } from 'src/common/entities';
import { RegistrationCustomResponseService } from './registration-custom-response.service';
import { RegistrationCustomResponseController } from './registration-custom-response.controller';
import { RegistrationCustomResponseRepository } from './registration-custom-response.repository';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';

@Module({
  imports: [TypeOrmModule.forFeature([RegistrationCustomResponse]), forwardRef(() => AuthModule), forwardRef(() => UserModule)],
  controllers: [RegistrationCustomResponseController],
  providers: [RegistrationCustomResponseService, RegistrationCustomResponseRepository, CommonDataService, AppLoggerService],
  exports: [RegistrationCustomResponseService, RegistrationCustomResponseRepository],
})
export class RegistrationCustomResponseModule {}
