import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';
import { IsInt, IsNotEmpty } from 'class-validator';
import { CreateRegistrationCustomResponseDto } from './create-registration-custom-response.dto';

export class UpdateRegistrationCustomResponseDto extends PartialType(
  OmitType(CreateRegistrationCustomResponseDto, ['createdBy', 'updatedBy'] as const),
) {
  @ApiProperty()
  @IsInt()
  @IsNotEmpty()
  updatedBy: number;
}
