import { ApiProperty } from '@nestjs/swagger';
import { IsInt, IsOptional } from 'class-validator';

export class CreateRegistrationCustomResponseDto {
  @ApiProperty()
  @IsInt()
  registrationId: number;

  @ApiProperty()
  @IsInt()
  questionId: number;

  @ApiProperty({ required: false, type: Object })
  @IsOptional()
  responseValue?: Record<string, any>;

  @ApiProperty()
  @IsInt()
  createdBy: number;

  @ApiProperty()
  @IsInt()
  updatedBy: number;
}
