import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { CommunicationTemplates, CommunicationTrack, ProgramRegistration, RegistrationApproval, RegistrationApprovalTrack } from 'src/common/entities';
import { RegistrationApprovalService } from './registration-approval.service';
import { RegistrationApprovalController } from './registration-approval.controller';
import { RegistrationApprovalRepository } from './registration-approval.repository';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { AwsS3Service } from 'src/common/services/awsS3.service';
import { ProgramRegistrationRepository } from 'src/program-registration/program-registration.repository';
import { RegistrationModule } from 'src/registration/registration.module';
import { CommunicationModule } from 'src/communication/communication.module';
import { ProgramRegistrationModule } from 'src/program-registration/program-registration.module';
import { RoomInventoryModule } from 'src/room-inventory/room-inventory.module';
import { AllocationClearingService } from 'src/common/services/allocation-clearing.service';

@Module({
  imports: [
    TypeOrmModule.forFeature([
      RegistrationApproval,
      ProgramRegistration,
      CommunicationTrack,
      RegistrationApprovalTrack,
      CommunicationTemplates,
    ]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
    forwardRef(() => RegistrationModule),
    forwardRef(() => CommunicationModule),
    forwardRef(() => ProgramRegistrationModule),
    forwardRef(() => RoomInventoryModule),
  ],
  controllers: [RegistrationApprovalController],
  providers: [
    RegistrationApprovalService,
    RegistrationApprovalRepository,
    CommonDataService,
    AppLoggerService,
    AwsS3Service,
    ProgramRegistrationRepository,
    AllocationClearingService,
  ],
  exports: [
    RegistrationApprovalService,
    RegistrationApprovalRepository,
    ProgramRegistrationRepository,
  ],
})
export class RegistrationApprovalModule {}
