import { ApiProperty, PartialType, OmitType } from '@nestjs/swagger';
import { CreateQuestionOptionDto } from './create-question-option.dto';
import { IsInt, IsNotEmpty } from 'class-validator';

export class UpdateQuestionOptionDto extends PartialType(
  OmitType(CreateQuestionOptionDto, ['createdBy', 'updatedBy','optionIds'] as const),
) {
  @ApiProperty({ description: 'ID of the option' })
  @IsInt({ message: 'The id field must be a valid integer.' })
  @IsNotEmpty({ message: 'The id field is required.' })
  optionId: number;

  @ApiProperty({ description: 'ID of the user updating the record' })
  @IsInt({ message: 'The updatedBy field must be a valid integer.' })
  @IsNotEmpty({ message: 'The updatedBy field is required.' })
  updatedBy: number;
}