import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Program } from 'src/common/entities/program.entity';
import { ProgramService } from './program.service';
import { ProgramController } from './program.controller';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { ProgramSession, ProgramType, User } from 'src/common/entities';
import { ProgramSessionRepository } from 'src/program-session/program-session.repository';
import { ProgramRepository } from './program.repository';
import { ProgramTypeRepository } from 'src/program-type/program-type.repository';
import { ProgramValidationService } from './program-validation.service';
import { FeatureFlagModule } from '../feature-flag/feature-flag.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([Program, User, ProgramType, ProgramSession]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
    FeatureFlagModule,
  ],
  controllers: [ProgramController],
  providers: [ProgramService, ProgramRepository, CommonDataService, ProgramSessionRepository, ProgramTypeRepository, ProgramValidationService],
  exports: [ProgramService, ProgramRepository, ProgramValidationService],
})
export class ProgramModule {}