// update-preference.dto.ts
import { ApiProperty } from '@nestjs/swagger';
import { IsArray, IsInt, ValidateNested, IsOptional } from 'class-validator';
import { Type } from 'class-transformer';
import { PreferenceItemDto } from './create-preference.dto';

export class UpdatePreferenceDto {
  @ApiProperty()
  @IsInt()
  programId: number;

  @ApiProperty({ type: [PreferenceItemDto] })
  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => PreferenceItemDto)
  preferences: PreferenceItemDto[];

  @ApiProperty()
  @IsInt()
  createdBy: number;

  @ApiProperty()
  @IsInt()
  updatedBy: number
}