// create-preference.dto.ts
import { ApiProperty } from '@nestjs/swagger';
import { IsArray, IsInt, ValidateNested, IsOptional } from 'class-validator';
import { Type } from 'class-transformer';

export class PreferenceItemDto {
  @ApiProperty()
  @IsInt()
  sessionId: number;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsInt()
  priorityOrder?: number;
}

export class CreatePreferenceDto {
  @ApiProperty()
  @IsInt()
  programId: number;

  @ApiProperty()
  @IsInt()
  registrationId: number;

  @ApiProperty({ type: [PreferenceItemDto] })
  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => PreferenceItemDto)
  preferences: PreferenceItemDto[];

  @ApiProperty()
  @IsInt()
  createdBy: number;

  @ApiProperty()
  @IsInt()
  updatedBy: number;
}