import { IsEnum, IsNotEmpty, IsNumber, IsOptional, IsPositive } from 'class-validator';
import { Type } from 'class-transformer';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import { PaymentEditRequestStatus } from 'src/common/enum/payment-edit-request-status.enum';

export class CreatePaymentEditRequestDto {
  @ApiProperty({
    description: 'ID of the payment to be edited',
    example: 12345,
  })
  @IsNotEmpty()
  @IsNumber({}, { message: 'Payment ID must be a number' })
  @IsPositive({ message: 'Payment ID must be positive' })
  @Type(() => Number)
  paymentId: number;
}


export class UpdatePaymentEditRequestDto {
  @ApiPropertyOptional({
    description: 'ID of the payment to be edited',
    example: 12345,
  })
  @IsOptional()
  @IsNumber({}, { message: 'Payment ID must be a number' })
  @IsPositive({ message: 'Payment ID must be positive' })
  @Type(() => Number)
  paymentId?: number;

  @ApiPropertyOptional({
    description: 'Status of the payment edit request',
    enum: PaymentEditRequestStatus,
    example: PaymentEditRequestStatus.REQUESTED,
  })
  @IsOptional()
  @IsEnum(PaymentEditRequestStatus, { message: 'Invalid request status' })
  requestStatus?: PaymentEditRequestStatus;
}

export class PaymentEditRequestDto {
  @ApiProperty({
    description: 'Status of the payment edit request',
    enum: PaymentEditRequestStatus,
    example: PaymentEditRequestStatus.REQUESTED,
  })
  @IsNotEmpty()
  @IsEnum([PaymentEditRequestStatus.REQUESTED, PaymentEditRequestStatus.CLOSED], {
    message: 'Invalid request status',
  })
  requestStatus: PaymentEditRequestStatus;
}
