// import { Test, TestingModule } from '@nestjs/testing';
// import { OptionCategoryController } from './option-category.controller';
// import { OptionCategoryService } from './option-category.service';
// import { CreateOptionCategoryDto } from './dto/create-option-category.dto';
// import { UpdateOptionCategoryDto } from './dto/update-option-category.dto';
// import { NotFoundException } from '@nestjs/common';

// describe('OptionCategoryController', () => {
//   let controller: OptionCategoryController;
//   let service: OptionCategoryService;

//   const mockService = {
//     create: jest.fn(),
//     findAll: jest.fn(),
//     findOne: jest.fn(),
//     findByCategoryWiseOptionsById: jest.fn(),
//     update: jest.fn(),
//     remove: jest.fn(),
//   };

//   beforeEach(async () => {
//     const module: TestingModule = await Test.createTestingModule({
//       controllers: [OptionCategoryController],
//       providers: [
//         {
//           provide: OptionCategoryService,
//           useValue: mockService,
//         },
//       ],
//     }).compile();

//     controller = module.get<OptionCategoryController>(OptionCategoryController);
//     service = module.get<OptionCategoryService>(OptionCategoryService);
//   });

//   it('should be defined', () => {
//     expect(controller).toBeDefined();
//   });

//   describe('create', () => {
//     it('should create a new category', async () => {
//       const dto: CreateOptionCategoryDto = { name: 'Test Category', createdBy: 1, updatedBy: 1 };
//       const result = { id: 1, name: 'Test Category' }; // Match controller's response format

//       mockService.create.mockResolvedValue(result);

//       expect(await controller.create(dto)).toEqual({
//         statusCode: 201,
//         message: 'Category created successfully',
//         data: { id: 1, name: 'Test Category' }, // Match respData in controller
//       });
//       expect(mockService.create).toHaveBeenCalledWith(dto);
//     });
//   });

//   describe('findAll', () => {
//     it('should return all categories with pagination and search', async () => {
//       const result = {
//         data: [{ id: 1, name: 'Test Category' }],
//         pagination: { totalPages: 1, pageNumber: 1, pageSize: 10, numberOfRecords: 1 },
//       };

//       mockService.findAll.mockResolvedValue(result);

//       // Update expected response to match controller's actual response
//       expect(await controller.findAll(10, 0, '')).toEqual({
//         statusCode: 200,
//         message: 'Categories retrieved successfully',
//         data: result, // Controller returns the full result
//       });
//       expect(mockService.findAll).toHaveBeenCalledWith(10, 0, '');
//     });

//     it('should handle empty result set', async () => {
//       const result = {
//         data: [],
//         pagination: { totalPages: 0, pageNumber: 1, pageSize: 10, numberOfRecords: 0 },
//       };

//       mockService.findAll.mockResolvedValue(result);

//       // Update expected response to match controller's actual response
//       expect(await controller.findAll()).toEqual({
//         statusCode: 200,
//         message: 'Categories retrieved successfully',
//         data: result, // Controller returns the full result
//       });
//     });
//   });

//   describe('findOne', () => {
//     it('should return a single category by ID', async () => {
//       const mockCategory = { id: 1, name: 'Test Category' };
//       mockService.findOne.mockResolvedValue(mockCategory);

//       // Update expected response to match controller's actual response
//       expect(await controller.findOne(1)).toEqual({
//         statusCode: 200,
//         message: 'Category retrieved successfully',
//         data: { id: 1, name: 'Test Category' }, // Match respData in controller
//       });
//       expect(mockService.findOne).toHaveBeenCalledWith(1);
//     });

//     it('should handle not found case gracefully', async () => {
//       // Mock to throw NotFoundException for non-existent category
//       mockService.findOne.mockImplementation(() => {
//         throw new NotFoundException('Category not found');
//       });

//       // Expect the controller to throw the same exception
//       await expect(controller.findOne(999)).rejects.toThrow(NotFoundException);
//     });
//   });

//   describe('findByCategoryWiseOptionsById', () => {
//     it('should return options by category ID with pagination and search', async () => {
//       const result = {
//         data: [{ id: 1, name: 'Option 1' }],
//         pagination: { totalPages: 1, pageNumber: 1, pageSize: 10, numberOfRecords: 1 },
//       };

//       mockService.findByCategoryWiseOptionsById.mockResolvedValue(result);

//       // Update expected response to match controller's actual response
//       expect(await controller.findByCategoryWiseOptionsById(1, 10, 0, '')).toEqual({
//         statusCode: 200,
//         message: 'Options retrieved successfully',
//         data: result, // Controller returns the full result
//       });
//       expect(mockService.findByCategoryWiseOptionsById).toHaveBeenCalledWith(1, 10, 0, '');
//     });

//     it('should return empty options list when none found', async () => {
//       const result = {
//         data: [],
//         pagination: { totalPages: 0, pageNumber: 1, pageSize: 10, numberOfRecords: 0 },
//       };

//       mockService.findByCategoryWiseOptionsById.mockResolvedValue(result);

//       // Update expected response to match controller's actual response
//       expect(await controller.findByCategoryWiseOptionsById(2)).toEqual({
//         statusCode: 200,
//         message: 'Options retrieved successfully',
//         data: result, // Controller returns the full result
//       });
//     });
//   });

//   describe('update', () => {
//     it('should update a category by ID', async () => {
//       const dto: UpdateOptionCategoryDto = { name: 'Updated Category', updatedBy: 1 };
//       const result = { id: 1, name: 'Updated Category' }; // Match controller's response format

//       mockService.update.mockResolvedValue(result);

//       // Update expected response to match controller's actual response
//       expect(await controller.update(1, dto)).toEqual({
//         statusCode: 200,
//         data: { id: 1, name: 'Updated Category' }, // Match respData in controller
//         message: 'Category updated successfully',
      
//       });
//       expect(mockService.update).toHaveBeenCalledWith(1, dto);
//     });
//   });

//   describe('remove', () => {
//     it('should delete a category by ID', async () => {
//       mockService.remove.mockResolvedValue(undefined);

//       expect(await controller.remove(1)).toEqual({
//         statusCode: 200,
//         message: 'Category deleted successfully',
//       });
//       expect(mockService.remove).toHaveBeenCalledWith(1);
//     });
//   });
// });