import { forwardRef, Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { CommunicationTemplates, CommunicationTrack, Message, Program, User, UserRole } from 'src/common/entities';
import { MessagesService } from './messages.service';
import { MessagesController } from './messages.controller';
import { MessagesRepository } from './messages.repository';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { CommunicationModule } from 'src/communication/communication.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([
      Message,
      Program,
      User,
      UserRole,
      CommunicationTrack,
      CommunicationTemplates,
    ]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
    forwardRef(() => CommunicationModule),
  ],
  controllers: [MessagesController],
  providers: [
    MessagesService,
    MessagesRepository,
    CommonDataService,
    AppLoggerService,
  ],
  exports: [MessagesService, MessagesRepository],
})
export class MessagesModule {}
