import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { LookupData } from 'src/common/entities/lookup-data.entity';
import { LookupDataService } from './lookup-data.service';
import { LookupDataController } from './lookup-data.controller';
import { LookupDataRepository } from './lookup-data.repository';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([LookupData]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
  ],
  controllers: [LookupDataController],
  providers: [LookupDataService, LookupDataRepository],
  exports: [LookupDataService, LookupDataRepository],
})
export class LookupDataModule {}
