import { BadRequestException, NotFoundException } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { RegistrationInvoiceDetail } from 'src/common/entities';
import { RegistrationInvoiceEinvoiceHistory } from 'src/common/entities/registration-invoice-einvoice-history.entity';
import { Repository } from 'typeorm';
import { CreateEinvoiceHistoryDto } from '../dto/invoice-einvoice-history.dto';

export class InvoiceEinvoiceHistoryService {
  constructor(
    @InjectRepository(RegistrationInvoiceEinvoiceHistory)
    private readonly einvoiceHistoryRepository: Repository<RegistrationInvoiceEinvoiceHistory>,

    @InjectRepository(RegistrationInvoiceDetail)
    private readonly invoiceDetailRepository: Repository<RegistrationInvoiceDetail>,
  ) {}

  async createEinvoiceHistory(
    data: CreateEinvoiceHistoryDto,
  ): Promise<RegistrationInvoiceEinvoiceHistory> {
    try {
      // Validate invoice exists if invoiceId is provided
      if (data.invoiceId) {
        const invoiceExists = await this.invoiceDetailRepository.findOne({
          where: { id: data.invoiceId }
        });

        if (!invoiceExists) {
          throw new NotFoundException(`Invoice with ID ${data.invoiceId} not found`);
        }
      }

      // Create new einvoice history record
      const einvoiceHistory = this.einvoiceHistoryRepository.create(data);

      return await this.einvoiceHistoryRepository.save({
        ...einvoiceHistory,
        createdAt: new Date(),
      });
    } catch (error) {
      if (error instanceof NotFoundException) {
        throw error;
      }
      throw new BadRequestException(`Failed to create einvoice history: ${error.message}`);
    }
  }
}
