import { Injectable } from '@nestjs/common';
import { FormSectionRepository } from './form-section.repository';
import { AppLoggerService } from 'src/common/services/logger.service';
import { handleKnownErrors } from 'src/common/utils/handle-error.util';
import { ERROR_CODES } from 'src/common/constants/error-string-constants';
import { FORM_SECTION_MESSAGES } from 'src/common/constants/strings-constants';

@Injectable()
export class FormSectionService {
  constructor(
    private readonly repository: FormSectionRepository,
    private readonly logger: AppLoggerService,
  ) {}

  async findAll(limit: number, offset: number, searchText: string) {
    this.logger.log(FORM_SECTION_MESSAGES.FETCHING_ALL_FORM_SECTIONS(limit, offset, searchText));
    try {
      return await this.repository.findAll(limit, offset, searchText);
    }
    catch (error) {
      this.logger.error('Error finding all form sections', error?.stack, { error, limit, offset, searchText });
      handleKnownErrors(ERROR_CODES.FORM_SECTION_FIND_FAILED, error);
    }
  }
}