import { registerAs } from '@nestjs/config';

export const communicationConfig = registerAs('communication', () => ({
  email: {
    zeptoApiKey: process.env.ZEPTO_API_KEY,
    zeptoWebhookSecret: process.env.ZEPTO_WEBHOOK_SECRET,
    zeptoApiUrl: process.env.ZEPTO_API_URL || 'https://api.zeptomail.in/v1.1',
    hdbBccEmail: process.env.HDB_BCC_EMAIL,
  },
  whatsapp: {
    watiApiUrl: process.env.WATI_API_URL,
    watiAccessToken: process.env.WATI_ACCESS_TOKEN,
    watiWebhookSecret: process.env.WATI_WEBHOOK_SECRET,
  },
}));