import { ApiProperty } from '@nestjs/swagger';

export class InvoiceTemplateDto {
  @ApiProperty()
  companyAddress: string;

  @ApiProperty()
  companyPAN: string;

  @ApiProperty()
  companyGST: string;

  @ApiProperty()
  companyCIN: string;

  @ApiProperty()
  invoiceNumber: string;

  @ApiProperty()
  currentDate: string;

  @ApiProperty({ required: false })
  placeOfSupply: string | null;

  @ApiProperty()
  seekerName: string;

  @ApiProperty()
  seekerAddress: string;

  @ApiProperty()
  seekerGstin: string;

  @ApiProperty()
  programName: string;

  @ApiProperty()
  reportingTime: string;

  @ApiProperty()
  checkOutTime: string;

  @ApiProperty()
  amount: string;

  @ApiProperty()
  igstCheck: boolean;

  @ApiProperty()
  igst: string;

  @ApiProperty()
  cgst: string;

  @ApiProperty()
  sgst: string;

  @ApiProperty()
  igstPercentage: number;

  @ApiProperty()
  cgstPercentage: number;

  @ApiProperty()
  sgstPercentage: number;

  @ApiProperty()
  totalAmount: number;

  @ApiProperty()
  amountInWords: string;

  @ApiProperty()
  qr: string;

  @ApiProperty()
  irpDate: string;

  @ApiProperty()
  acknowledgeNumber: string;

  @ApiProperty()
  irn: string;
}

export class ProFormaInvoice {
  @ApiProperty()
  startDate: string;

  @ApiProperty()
  endDate: string;

  @ApiProperty()
  companyAddress: string;

  @ApiProperty()
  invoiceNumber: string;

  @ApiProperty()
  currentDate: string;

  @ApiProperty()
  companyGST: string;

  @ApiProperty()
  companyCIN: string;

  @ApiProperty()
  seekerName: string;

  @ApiProperty()
  seekerAddress: string;

  @ApiProperty()
  amount: number;

  @ApiProperty()
  totalAmount: number;

  @ApiProperty()
  amountInWords: string;

  @ApiProperty()
  gstAmount: number;

  @ApiProperty()
  programName: string;

  @ApiProperty()
  gstPercentage: number;

  @ApiProperty()
  companyPAN: string;

  @ApiProperty()
  checkOutTime: string;

  @ApiProperty()
  reportingTime: string;
}
