// entities/registration-payment-detail-history.entity.ts
import {
    Entity,
    PrimaryGeneratedColumn,
    Column,
    CreateDateColumn,
    UpdateDateColumn,
    ManyToOne,
    JoinColumn,
  } from 'typeorm';
  import { PaymentModeEnum } from '../enum/payment-mode.enum';
  import { PaymentStatusEnum } from '../enum/payment-status.enum';
  import { RegistrationPaymentDetail, User } from './index';
import { RazorpayPaymentStatusEnum } from '../enum/razorpay-payment-status.enum';
  
  @Entity('hdb_registration_payment_details_history')
  export class RegistrationPaymentDetailsHistory {
    @PrimaryGeneratedColumn('increment', { type: 'bigint' })
    id: number;
  
    @Column({ name: 'payment_details_id', type: 'bigint' })
    paymentDetailsId: number;
  
    @Column({ name: 'payment_mode', type: 'enum', enum: PaymentModeEnum, nullable: true })
    paymentMode: PaymentModeEnum;
  
    @Column({ name: 'razorpay_id', type: 'varchar', length: 100, nullable: true })
    razorpayId: string | null;
  
    @Column({ name: 'offline_meta', type: 'jsonb', nullable: true })
    offlineMeta: Record<string, any> | null;
  
    @Column({
      name: 'payment_status',
      type: 'enum',
      enum: PaymentStatusEnum,
      default: PaymentStatusEnum.DRAFT,
    })
    paymentStatus: PaymentStatusEnum;

  @Column({ name: 'portal_online_payment_status', type: 'enum', enum: PaymentStatusEnum, nullable: true })
  portalOnlinePaymentStatus: RazorpayPaymentStatusEnum | null;

  @Column({ name: 'portal_online_payment_attempt_status', type: 'jsonb', nullable: true })
  portalOnlinePaymentAttemptStatus: Record<string, any>[] | null;

  @Column({ name: 'webhook_online_payment_status', type: 'enum', enum: PaymentStatusEnum, nullable: true })
  webhookOnlinePaymentStatus: RazorpayPaymentStatusEnum | null;

  @Column({ name: 'webhook_online_payment_attempt_status', type: 'jsonb', nullable: true })
  webhookOnlinePaymentAttemptStatus: Record<string, any>[] | null;

  @Column({ name: 'gateway_online_payment_status', type: 'enum', enum: PaymentStatusEnum, nullable: true })
  gatewayOnlinePaymentStatus: RazorpayPaymentStatusEnum | null;

  @Column({ name: 'gateway_online_payment_attempt_status', type: 'jsonb', nullable: true })
  gatewayOnlinePaymentAttemptStatus: Record<string, any>[] | null;

    @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
    createdAt: Date;
  
    @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP', onUpdate: 'CURRENT_TIMESTAMP' })
    updatedAt: Date;
  
    @Column({ name: 'created_by', type: 'bigint', nullable: true })
    createdBy: number | null;
  
    @Column({ name: 'updated_by', type: 'bigint', nullable: true })
    updatedBy: number | null;
  
    // Relations
    @ManyToOne(() => RegistrationPaymentDetail, { nullable: false, onDelete: 'CASCADE' })
    @JoinColumn({ name: 'payment_details_id' })
    paymentDetail: RegistrationPaymentDetail;
  
    @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
    @JoinColumn({ name: 'created_by' })
    createdByUser: User | null;
  
    @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
    @JoinColumn({ name: 'updated_by' })
    updatedByUser: User | null;
  
    constructor(partial: Partial<RegistrationPaymentDetailsHistory>) {
      Object.assign(this, partial);
    }
  }