import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  DeleteDateColumn,
  ManyToOne,
  OneToMany,
  JoinColumn,
} from 'typeorm';
import { User } from './user.entity';
import { Program } from './program.entity';
import { RegistrationPairMap } from './registration-pair-map.entity';

/**
 * Entity representing registration pairs for programs and sub-programs
 * Contains pair codes and sequence information for paired registrations
 */
@Entity('registration_pair')
export class RegistrationPair {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ name: 'pair_code', type: 'varchar', length: 10, nullable: false })
  pairCode: string;

  @Column({ name: 'seq_number', type: 'bigint', nullable: false })
  seqNumber: number;

  @Column({ name: 'program_id', type: 'bigint', nullable: false })
  programId: number;

  @Column({ name: 'sub_program_id', type: 'bigint', nullable: true })
  subProgramId: number;

  @Column({ name: 'remarks', type: 'text', nullable: true })
  remarks: string;

  @CreateDateColumn({ name: 'created_at', type: 'timestamp', nullable: false })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamp', nullable: true })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamp', nullable: true })
  deletedAt: Date;

  @Column({ name: 'created_by', type: 'bigint', nullable: false })
  createdById: number;

  @Column({ name: 'updated_by', type: 'bigint', nullable: true })
  updatedById: number;

  // Relationships
  @ManyToOne(() => Program, { nullable: false })
  @JoinColumn({ name: 'program_id' })
  program: Program;

  @ManyToOne(() => Program, { nullable: true })
  @JoinColumn({ name: 'sub_program_id' })
  subProgram: Program;

  @ManyToOne(() => User, { nullable: false })
  @JoinColumn({ name: 'created_by' })
  createdBy: User;

  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'updated_by' })
  updatedBy: User;

  @OneToMany(() => RegistrationPairMap, (pairMap) => pairMap.registrationPair)
  registrationPairMaps: RegistrationPairMap[];

  constructor(partial: Partial<RegistrationPair>) {
    Object.assign(this, partial);
  }
}