import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  DeleteDateColumn,
  ManyToOne,
  JoinColumn,
} from 'typeorm';
import { User } from './user.entity';
import { RegistrationGroup } from './registration-group.entity';

/**
 * Entity representing the mapping of program registrations to registration groups
 * Links individual registrations to their respective groups
 */
@Entity('registration_group_map')
export class RegistrationGroupMap {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ name: 'registration_group_id', type: 'bigint', nullable: false })
  registrationGroupId: number;

  @Column({ name: 'registration_id', type: 'bigint', nullable: false })
  registrationId: number;

  @CreateDateColumn({ name: 'created_at', type: 'timestamp', nullable: false })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamp', nullable: true })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamp', nullable: true })
  deletedAt: Date;

  @Column({ name: 'created_by', type: 'bigint', nullable: false })
  createdById: number;

  @Column({ name: 'updated_by', type: 'bigint', nullable: true })
  updatedById: number;

  // Relationships
  @ManyToOne(() => RegistrationGroup, (group) => group.registrationGroupMaps, { nullable: false })
  @JoinColumn({ name: 'registration_group_id' })
  registrationGroup: RegistrationGroup;

  @ManyToOne(() => User, { nullable: false })
  @JoinColumn({ name: 'created_by' })
  createdBy: User;

  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'updated_by' })
  updatedBy: User;

  constructor(partial: Partial<RegistrationGroupMap>) {
    Object.assign(this, partial);
  }
}