import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  DeleteDateColumn,
  ManyToOne,
  JoinColumn,
} from 'typeorm';
import { Program } from './program.entity';
import { Question } from './question.entity';
import { User } from './user.entity';
import { ProgramSession } from './program-session.entity';
import { FormSection } from './form-section.entity';
import { RegistrationLevelEnum } from '../enum/registration-level.enum';

@Entity('hdb_program_question')
export class ProgramQuestion {
  @PrimaryGeneratedColumn()
  id: number;

  @ManyToOne(() => Program, program => program.programQuestionMaps, { nullable: false, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'program_id' })
  program: Program;

  @ManyToOne(() => Question, question => question.programQuestionMaps, { nullable: false, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'question_id' })
  question: Question;

  @ManyToOne(() => ProgramSession, { nullable: true, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'program_session_id' })
  programSession: ProgramSession | null;

  @Column({ 
    name: 'registration_level', 
    type: 'enum', 
    enum: RegistrationLevelEnum,
    default: RegistrationLevelEnum.PROGRAM 
  })
  registrationLevel: RegistrationLevelEnum;

  @Column({
    name: 'display_order',
    type: 'integer',
    default: 0,
    nullable: true
  })
  displayOrder: number;

  @ManyToOne(() => FormSection, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'form_section_id' })
  programQuestionFormSection: FormSection | null;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP', onUpdate: 'CURRENT_TIMESTAMP' })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamptz', nullable: true, default: null })
  deletedAt: Date;

  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'created_by' })
  createdBy: User;

  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'updated_by' })
  updatedBy: User;

  constructor(partial: Partial<ProgramQuestion>) {
    Object.assign(this, partial);
  }
}