import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  JoinColumn,
  CreateDateColumn,
} from 'typeorm';
import { Program, User, UserRole } from './index';
import { Auditable } from 'src/audit-history/decorators/auditable.decorator';
import { SkipAudit } from 'src/audit-history/decorators/skip-audit.decorator';

@Entity('program_message')
@Auditable()
export class Message {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ name: 'program_id' })
  programId: number;

  @Column({ name: 'seeker_id' })
  seekerId: number;

  @Column({ name: 'sender_id' })
  senderId: number;

  @Column({ name: 'receiver_id', nullable: true })
  receiverId?: number;

  @Column({ name: 'receiver_role_flag', default: false })
  receiverRoleFlag: boolean;

  @Column({ name: 'cc_role_id', nullable: true })
  receiverRoleId?: number;

  @Column({ name: 'content', type: 'text' })
  content: string;

  @Column({ name: 'audit_ref_id', type: 'bigint', nullable: true })
  auditRefId: number;

  @Column({ name: 'parent_ref_id', type: 'bigint', nullable: true })
  parentRefId: number;

  @SkipAudit()
  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'created_by' })
  createdBy: User;

  @SkipAudit()
  @ManyToOne(() => Program, { nullable: false })
  @JoinColumn({ name: 'program_id' })
  program: Program;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: false })
  @JoinColumn({ name: 'seeker_id' })
  seeker: User;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: false })
  @JoinColumn({ name: 'sender_id' })
  sender: User;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'receiver_id' })
  receiver: User;

  @SkipAudit()
  @ManyToOne(() => UserRole, { nullable: true })
  @JoinColumn({ name: 'cc_role_id' })
  receiverRole: UserRole;

  constructor(partial: Partial<Message>) {
    Object.assign(this, partial);
  }
}
